/*
 * Decompiled with CFR 0.152.
 */
package lib;

import lib.BitsLong;
import org.junit.Test;
import test.BaseTest;

public class TestBitsLong
extends BaseTest {
    @Test
    public void testMask1() {
        long v = BitsLong.mask(0, 1);
        this.check(1L, v);
    }

    @Test
    public void testMask2() {
        long v = BitsLong.mask(0, 2);
        this.check(3L, v);
    }

    @Test
    public void testMask3() {
        long v = BitsLong.mask(1, 2);
        this.check(2L, v);
    }

    @Test
    public void testMask4() {
        long v = BitsLong.mask(0, 64);
        this.check(-1L, v);
    }

    @Test
    public void testMask5() {
        long v = BitsLong.mask(16, 48);
        this.check(0xFFFFFFFF0000L, v);
    }

    @Test
    public void testMask6() {
        long v = BitsLong.mask(16, 64);
        this.check(-65536L, v);
    }

    @Test
    public void testMask7() {
        long v = BitsLong.mask(0, 0);
        this.check(0L, v);
    }

    @Test
    public void testMaskZero1() {
        long v = BitsLong.maskZero(0, 1);
        this.check(-2L, v);
    }

    @Test
    public void testMaskZero2() {
        long v = BitsLong.maskZero(0, 2);
        this.check(-4L, v);
    }

    @Test
    public void testMaskZero3() {
        long v = BitsLong.maskZero(1, 2);
        this.check(-3L, v);
    }

    @Test
    public void testMaskZero4() {
        long v = BitsLong.maskZero(0, 64);
        this.check(0L, v);
    }

    @Test
    public void testMaskZero5() {
        long v = BitsLong.maskZero(16, 48);
        this.check(-281474976645121L, v);
    }

    @Test
    public void testMaskZero6() {
        long v = BitsLong.maskZero(16, 64);
        this.check(65535L, v);
    }

    @Test
    public void testMaskZero7() {
        long v = BitsLong.maskZero(0, 0);
        this.check(-1L, v);
    }

    @Test
    public void testClear1() {
        long v = 61680L;
        v = BitsLong.clear(v, 4, 8);
        String s = Long.toHexString(v);
        this.check(61440L, v);
    }

    @Test
    public void testClear2() {
        long v = Long.MIN_VALUE;
        v = BitsLong.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(0L, v);
    }

    @Test
    public void testClear3() {
        long v = -4611686018427387904L;
        v = BitsLong.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(0x4000000000000000L, v);
    }

    @Test
    public void testClear4() {
        long v = -1L;
        v = BitsLong.clear(v, 63, 64);
        String s = Long.toHexString(v);
        this.check(Long.MAX_VALUE, v);
    }

    @Test
    public void testClear5() {
        long v = -1L;
        v = BitsLong.clear(v, 32, 64);
        String s = Long.toHexString(v);
        this.check(0xFFFFFFFFL, v);
    }

    @Test
    public void testClear6() {
        long v = -1L;
        v = BitsLong.clear(v, 0, 32);
        String s = Long.toHexString(v);
        this.check(-4294967296L, v);
    }

    @Test
    public void testClear7() {
        long v = -1L;
        v = BitsLong.clear(v, 0, 0);
        String s = Long.toHexString(v);
        this.check(-1L, v);
    }

    @Test
    public void testSet1() {
        long v = 0L;
        v = BitsLong.set(v, 0, 1);
        this.check(1L, v);
    }

    @Test
    public void testSet2() {
        long v = 1L;
        v = BitsLong.set(v, 0, 1);
        this.check(1L, v);
    }

    @Test
    public void testSet3() {
        long v = 240L;
        v = BitsLong.set(v, 0, 1);
        this.check(241L, v);
    }

    @Test
    public void testSet4() {
        long v = -1085102592571150096L;
        v = BitsLong.set(v, 0, 8);
        this.check(-1085102592571150081L, v);
    }

    @Test
    public void testSet5() {
        long v = 0L;
        v = BitsLong.set(v, 16, 48);
        this.check(0xFFFFFFFF0000L, v);
    }

    @Test
    public void testSet6() {
        long v = 0L;
        v = BitsLong.set(v, 63, 64);
        this.check(Long.MIN_VALUE, v);
    }

    @Test
    public void testSet7() {
        long v = 0L;
        v = BitsLong.set(v, 62, 64);
        this.check(-4611686018427387904L, v);
    }

    @Test
    public void testSet8() {
        long v = 0L;
        v = BitsLong.set(v, 0, 64);
        this.check(-1L, v);
    }

    @Test
    public void testSet9() {
        long v = 0L;
        v = BitsLong.set(v, 10, 10);
        this.check(0L, v);
    }

    @Test
    public void testSetBit1() {
        long v = 0L;
        v = BitsLong.set(v, 0);
        this.check(1L, v);
    }

    @Test
    public void testSetBit2() {
        long v = 0L;
        v = BitsLong.set(v, 1);
        this.check(2L, v);
    }

    @Test
    public void testSetBit3() {
        long v = 1L;
        v = BitsLong.set(v, 0);
        this.check(1L, v);
    }

    @Test
    public void testSetBit4() {
        long v = -1L;
        v = BitsLong.set(v, 0);
        this.check(-1L, v);
    }

    @Test
    public void testSetBit5() {
        long v = 0L;
        v = BitsLong.set(v, 62);
        this.check(0x4000000000000000L, v);
    }

    @Test
    public void testSetBit6() {
        long v = 0L;
        v = BitsLong.set(v, 63);
        this.check(Long.MIN_VALUE, v);
    }

    @Test
    public void testBitTest1() {
        long v = 0L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, false, 0));
    }

    @Test
    public void testBitTest2() {
        long v = 1L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, true, 0));
    }

    @Test
    public void testBitTest3() {
        long v = -1L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, true, 63));
    }

    @Test
    public void testBitTest4() {
        long v = Long.MAX_VALUE;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, false, 63));
    }

    @Test
    public void testBitsTest1() {
        long v = -81985529216486896L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, 0L, 0, 4));
    }

    @Test
    public void testBitsTest2() {
        long v = -81985529216486896L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, 16L, 0, 8));
    }

    @Test
    public void testBitsTest3() {
        long v = -81985529216486896L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, v, 0, 64));
    }

    @Test
    public void testBitsTest4() {
        long v = -81985529216486896L;
        TestBitsLong.assertFalse((boolean)BitsLong.test(v, 0L, 0, 64));
    }

    @Test
    public void testBitsTest5() {
        long v = -81985529216486896L;
        TestBitsLong.assertTrue((boolean)BitsLong.test(v, 205163983011840L, 16, 48));
    }

    @Test
    public void testIsSet1() {
        long v = 16L;
        BitsLong.isSet(v, 4);
        TestBitsLong.assertTrue((boolean)BitsLong.isSet(v, 4));
        TestBitsLong.assertFalse((boolean)BitsLong.isSet(v, 3));
        TestBitsLong.assertFalse((boolean)BitsLong.isSet(v, 5));
    }

    @Test
    public void testAccess1() {
        long v = -1L;
        v = BitsLong.access(v, 4, 8);
        this.check(240L, v);
    }

    @Test
    public void testAccess2() {
        long v = -81985529216486896L;
        v = BitsLong.access(v, 0, 8);
        this.check(16L, v);
    }

    @Test
    public void testAccess3() {
        long v = -81985529216486896L;
        v = BitsLong.access(v, 0, 64);
        this.check(-81985529216486896L, v);
    }

    @Test
    public void testAccess4() {
        long v = -81985529216486896L;
        v = BitsLong.access(v, 62, 64);
        this.check(-4611686018427387904L, v);
    }

    @Test
    public void testAccess5() {
        long v = -81985529216486896L;
        v = BitsLong.access(v, 0, 2);
        this.check(0L, v);
    }

    @Test
    public void testPack1() {
        long v = 0L;
        v = BitsLong.pack(v, 15L, 0, 4);
        this.check(15L, v);
    }

    @Test
    public void testPack2() {
        long v = 240L;
        v = BitsLong.pack(v, 2L, 0, 4);
        this.check(242L, v);
    }

    @Test
    public void testPack3() {
        long v = -1L;
        v = BitsLong.pack(v, 2L, 0, 8);
        this.check(-254L, v);
    }

    @Test
    public void testPack4() {
        long v = -4294967296L;
        v = BitsLong.pack(v, 2L, 16, 32);
        this.check(-4294836224L, v);
    }

    @Test
    public void testPack5() {
        long v = -4294967296L;
        v = BitsLong.pack(v, 65535L, 16, 32);
        this.check(-65536L, v);
    }

    @Test
    public void testUnpack1() {
        long v = -6067004223159161907L;
        v = BitsLong.unpack(v, 0, 4);
        this.check(13L, v);
    }

    @Test
    public void testUnpack2() {
        long v = -6067004223159161907L;
        v = BitsLong.unpack(v, 63, 64);
        this.check(1L, v);
    }

    @Test
    public void testUnpack3() {
        long v = -6067004223159161907L;
        v = BitsLong.unpack(v, 56, 64);
        this.check(171L, v);
    }

    @Test
    public void testUnpack4() {
        long v = -6067173106999841843L;
        v = BitsLong.unpack(v, 32, 48);
        this.check(4660L, v);
    }

    @Test
    public void testUnpackStr1() {
        String s = "ABCD";
        long v = BitsLong.unpack(s, 0, 4);
        this.check(43981L, v);
    }

    @Test
    public void testUnpackStr2() {
        String s = "ABCD";
        long v = BitsLong.unpack(s, 2, 4);
        this.check(205L, v);
    }

    @Test
    public void testUnpackStr3() {
        String s = "ABCD";
        long v = BitsLong.unpack(s, 0, 2);
        this.check(171L, v);
    }

    private void check(long expected, long actual) {
        this.check(null, expected, actual);
    }

    private void check(String msg, long expected, long actual) {
        if (expected == actual) {
            return;
        }
        String s = "Expected: " + Long.toHexString(expected) + " : Got: " + Long.toHexString(actual);
        if (msg != null) {
            s = msg + ": " + s;
        }
        TestBitsLong.assertFalse((String)s, (boolean)true);
    }
}

