/*
 * Decompiled with CFR 0.152.
 */
package lib;

import lib.BitsInt;
import org.junit.Test;
import test.BaseTest;

public class TestBitsInt
extends BaseTest {
    @Test
    public void testMask1() {
        int v = BitsInt.mask(0, 1);
        this.check(1, v);
    }

    @Test
    public void testMask2() {
        int v = BitsInt.mask(0, 2);
        this.check(3, v);
    }

    @Test
    public void testMask3() {
        int v = BitsInt.mask(1, 2);
        this.check(2, v);
    }

    @Test
    public void testMask4() {
        int v = BitsInt.mask(0, 32);
        this.check(-1, v);
    }

    @Test
    public void testMask5() {
        int v = BitsInt.mask(16, 24);
        this.check(0xFF0000, v);
    }

    @Test
    public void testMask6() {
        int v = BitsInt.mask(16, 32);
        this.check(-65536, v);
    }

    @Test
    public void testMask7() {
        int v = BitsInt.mask(0, 0);
        this.check(0, v);
    }

    @Test
    public void testMaskZero1() {
        int v = BitsInt.maskZero(0, 1);
        this.check(-2, v);
    }

    @Test
    public void testMaskZero2() {
        int v = BitsInt.maskZero(0, 2);
        this.check(-4, v);
    }

    @Test
    public void testMaskZero3() {
        int v = BitsInt.maskZero(1, 2);
        this.check(-3, v);
    }

    @Test
    public void testMaskZero4() {
        int v = BitsInt.maskZero(0, 32);
        this.check(0, v);
    }

    @Test
    public void testMaskZero5() {
        int v = BitsInt.maskZero(16, 24);
        this.check(-16711681, v);
    }

    @Test
    public void testMaskZero6() {
        int v = BitsInt.maskZero(16, 32);
        this.check(65535, v);
    }

    @Test
    public void testMaskZero7() {
        int v = BitsInt.maskZero(0, 0);
        this.check(-1, v);
    }

    @Test
    public void testClear1() {
        int v = 61680;
        v = BitsInt.clear(v, 4, 8);
        String s = Integer.toHexString(v);
        this.check(61440, v);
    }

    @Test
    public void testClear2() {
        int v = Integer.MIN_VALUE;
        v = BitsInt.clear(v, 31, 32);
        String s = Integer.toHexString(v);
        this.check(0, v);
    }

    @Test
    public void testClear3() {
        int v = -1073741824;
        v = BitsInt.clear(v, 31, 32);
        String s = Integer.toHexString(v);
        this.check(0x40000000, v);
    }

    @Test
    public void testClear4() {
        int v = -1;
        v = BitsInt.clear(v, 31, 32);
        String s = Integer.toHexString(v);
        this.check(Integer.MAX_VALUE, v);
    }

    @Test
    public void testClear5() {
        int v = -1;
        v = BitsInt.clear(v, 16, 32);
        String s = Integer.toHexString(v);
        this.check(65535, v);
    }

    @Test
    public void testClear6() {
        int v = -1;
        v = BitsInt.clear(v, 0, 16);
        String s = Integer.toHexString(v);
        this.check(-65536, v);
    }

    @Test
    public void testClear7() {
        int v = -1;
        v = BitsInt.clear(v, 0, 0);
        String s = Integer.toHexString(v);
        this.check(-1, v);
    }

    @Test
    public void testSet1() {
        int v = 0;
        v = BitsInt.set(v, 0, 1);
        this.check(1, v);
    }

    @Test
    public void testSet2() {
        int v = 1;
        v = BitsInt.set(v, 0, 1);
        this.check(1, v);
    }

    @Test
    public void testSet3() {
        int v = 240;
        v = BitsInt.set(v, 0, 1);
        this.check(241, v);
    }

    @Test
    public void testSet4() {
        int v = -252645136;
        v = BitsInt.set(v, 0, 8);
        this.check(-252645121, v);
    }

    @Test
    public void testSet5() {
        int v = 0;
        v = BitsInt.set(v, 16, 24);
        this.check(0xFF0000, v);
    }

    @Test
    public void testSet6() {
        int v = 0;
        v = BitsInt.set(v, 31, 32);
        this.check(Integer.MIN_VALUE, v);
    }

    @Test
    public void testSet7() {
        int v = 0;
        v = BitsInt.set(v, 30, 32);
        this.check(-1073741824, v);
    }

    @Test
    public void testSet8() {
        int v = 0;
        v = BitsInt.set(v, 0, 32);
        this.check(-1, v);
    }

    @Test
    public void testSet9() {
        int v = 0;
        v = BitsInt.set(v, 10, 10);
        this.check(0, v);
    }

    @Test
    public void testSetBit1() {
        int v = 0;
        v = BitsInt.set(v, 0);
        this.check(1, v);
    }

    @Test
    public void testSetBit2() {
        int v = 0;
        v = BitsInt.set(v, 1);
        this.check(2, v);
    }

    @Test
    public void testSetBit3() {
        int v = 1;
        v = BitsInt.set(v, 0);
        this.check(1, v);
    }

    @Test
    public void testSetBit4() {
        int v = -1;
        v = BitsInt.set(v, 0);
        this.check(-1, v);
    }

    @Test
    public void testSetBit5() {
        int v = 0;
        v = BitsInt.set(v, 30);
        this.check(0x40000000, v);
    }

    @Test
    public void testSetBit6() {
        int v = 0;
        v = BitsInt.set(v, 31);
        this.check(Integer.MIN_VALUE, v);
    }

    @Test
    public void testBitTest1() {
        int v = 0;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, false, 0));
    }

    @Test
    public void testBitTest2() {
        int v = 1;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, true, 0));
    }

    @Test
    public void testBitTest3() {
        int v = -1;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, true, 31));
    }

    @Test
    public void testBitTest4() {
        int v = Integer.MAX_VALUE;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, false, 31));
    }

    @Test
    public void testBitsTest1() {
        int v = 1985229328;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, 0, 0, 4));
    }

    @Test
    public void testBitsTest2() {
        int v = 1985229328;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, 16, 0, 8));
    }

    @Test
    public void testBitsTest3() {
        int v = 1985229328;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, v, 0, 32));
    }

    @Test
    public void testBitsTest4() {
        int v = 1985229328;
        TestBitsInt.assertFalse((boolean)BitsInt.test(v, 0, 0, 32));
    }

    @Test
    public void testBitsTest5() {
        int v = 1985229328;
        TestBitsInt.assertTrue((boolean)BitsInt.test(v, 5517824, 8, 24));
    }

    @Test
    public void testIsSet1() {
        int v = 16;
        BitsInt.isSet(v, 4);
        TestBitsInt.assertTrue((boolean)BitsInt.isSet(v, 4));
        TestBitsInt.assertFalse((boolean)BitsInt.isSet(v, 3));
        TestBitsInt.assertFalse((boolean)BitsInt.isSet(v, 5));
    }

    @Test
    public void testAccess1() {
        int v = -1;
        v = BitsInt.access(v, 4, 8);
        this.check(240, v);
    }

    @Test
    public void testAccess2() {
        int v = 1985229328;
        v = BitsInt.access(v, 0, 8);
        this.check(16, v);
    }

    @Test
    public void testAccess3() {
        int v = 1985229328;
        v = BitsInt.access(v, 0, 32);
        this.check(1985229328, v);
    }

    @Test
    public void testAccess4() {
        int v = -17550832;
        v = BitsInt.access(v, 30, 32);
        this.check(-1073741824, v);
    }

    @Test
    public void testAccess5() {
        int v = 1985229328;
        v = BitsInt.access(v, 0, 2);
        this.check(0, v);
    }

    @Test
    public void testPack1() {
        int v = 0;
        v = BitsInt.pack(v, 15, 0, 4);
        this.check(15, v);
    }

    @Test
    public void testPack2() {
        int v = 240;
        v = BitsInt.pack(v, 2, 0, 4);
        this.check(242, v);
    }

    @Test
    public void testPack3() {
        int v = -1;
        v = BitsInt.pack(v, 2, 0, 8);
        this.check(-254, v);
    }

    @Test
    public void testPack4() {
        int v = -65536;
        v = BitsInt.pack(v, 2, 8, 16);
        this.check(-65024, v);
    }

    @Test
    public void testPack5() {
        int v = -65536;
        v = BitsInt.pack(v, 255, 8, 16);
        this.check(-256, v);
    }

    @Test
    public void testUnpack1() {
        int v = -1412584499;
        v = BitsInt.unpack(v, 0, 4);
        this.check(13, v);
    }

    @Test
    public void testUnpack2() {
        int v = -1412584499;
        v = BitsInt.unpack(v, 31, 32);
        this.check(1, v);
    }

    @Test
    public void testUnpack3() {
        int v = -1412584499;
        v = BitsInt.unpack(v, 24, 32);
        this.check(171, v);
    }

    @Test
    public void testUnpack4() {
        int v = -1424870195;
        v = BitsInt.unpack(v, 8, 24);
        this.check(4660, v);
    }

    @Test
    public void testUnpackStr1() {
        String s = "ABCD";
        int v = BitsInt.unpack(s, 0, 4);
        this.check(43981, v);
    }

    @Test
    public void testUnpackStr2() {
        String s = "ABCD";
        int v = BitsInt.unpack(s, 2, 4);
        this.check(205, v);
    }

    @Test
    public void testUnpackStr3() {
        String s = "ABCD";
        int v = BitsInt.unpack(s, 0, 2);
        this.check(171, v);
    }

    private void check(int expected, int actual) {
        this.check(null, expected, actual);
    }

    private void check(String msg, int expected, int actual) {
        if (expected == actual) {
            return;
        }
        String s = "Expected: " + Integer.toHexString(expected) + " : Got: " + Integer.toHexString(actual);
        if (msg != null) {
            s = msg + ": " + s;
        }
        TestBitsInt.assertFalse((String)s, (boolean)true);
    }
}

