/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import lib.Alg;
import org.junit.Test;
import test.BaseTest;

public class TestAlg
extends BaseTest {
    @Test
    public void linear1() {
        int[] data = new int[]{1, 2, 3};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.linearSearch(b, 1);
        TestAlg.assertEquals((long)0L, (long)idx);
        idx = Alg.linearSearch(b, 2);
        TestAlg.assertEquals((long)1L, (long)idx);
        idx = Alg.linearSearch(b, 3);
        TestAlg.assertEquals((long)2L, (long)idx);
    }

    @Test
    public void linear2() {
        int[] data = new int[]{2, 4, 6};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.linearSearch(b, 1);
        TestAlg.assertEquals((long)-1L, (long)idx);
        idx = Alg.linearSearch(b, 3);
        TestAlg.assertEquals((long)-2L, (long)idx);
        idx = Alg.linearSearch(b, 5);
        TestAlg.assertEquals((long)-3L, (long)idx);
        idx = Alg.linearSearch(b, 7);
        TestAlg.assertEquals((long)-4L, (long)idx);
    }

    @Test
    public void linear3() {
        int[] data = new int[]{};
        IntBuffer b = TestAlg.make(data);
        int idx = Alg.linearSearch(b, 1);
        TestAlg.assertEquals((long)-1L, (long)idx);
    }

    @Test
    public void linear4() {
        int[] data = new int[]{9};
        IntBuffer b = TestAlg.make(data);
        int idx = Alg.linearSearch(b, 1);
        TestAlg.assertEquals((long)-1L, (long)idx);
        idx = Alg.linearSearch(b, 9);
        TestAlg.assertEquals((long)0L, (long)idx);
        idx = Alg.linearSearch(b, 100);
        TestAlg.assertEquals((long)-2L, (long)idx);
    }

    @Test
    public void linear5() {
        int[] data = new int[]{2, 4, 6, 8, 10};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.linearSearch(b, 1, 4, 6);
        TestAlg.assertEquals((long)2L, (long)idx);
        idx = Alg.linearSearch(b, 1, 4, 5);
        TestAlg.assertEquals((long)-3L, (long)idx);
        idx = Alg.linearSearch(b, 1, 4, 2);
        TestAlg.assertEquals((long)-2L, (long)idx);
        idx = Alg.linearSearch(b, 1, 4, 10);
        TestAlg.assertEquals((long)-5L, (long)idx);
    }

    @Test
    public void linear6() {
        int[] data = new int[]{2, 4, 6, 8, 10};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.linearSearch(b, 3, 3, 6);
        TestAlg.assertEquals((long)-4L, (long)idx);
        idx = Alg.linearSearch(b, 3, 3, 5);
        TestAlg.assertEquals((long)-4L, (long)idx);
        idx = Alg.linearSearch(b, 3, 3, 50);
        TestAlg.assertEquals((long)-4L, (long)idx);
    }

    @Test
    public void linear7() {
        int[] data = new int[]{2, 4, 4, 8, 8};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.linearSearch(b, 4);
        TestAlg.assertEquals((long)1L, (long)idx);
        idx = Alg.linearSearch(b, 8);
        TestAlg.assertEquals((long)3L, (long)idx);
    }

    @Test
    public void binary1() {
        int[] data = new int[]{1, 2, 3};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 1);
        TestAlg.search(b, 2);
        TestAlg.search(b, 3);
    }

    @Test
    public void binary2() {
        int[] data = new int[]{2, 4, 6};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 1);
        TestAlg.search(b, 3);
        TestAlg.search(b, 5);
        TestAlg.search(b, 7);
    }

    @Test
    public void binary3() {
        int[] data = new int[]{};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 1);
    }

    @Test
    public void binary4() {
        int[] data = new int[]{9};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 1);
        TestAlg.search(b, 9);
        TestAlg.search(b, 100);
    }

    @Test
    public void binary5() {
        int[] data = new int[]{2, 4, 6, 8, 10};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 6, 1, 4);
        TestAlg.search(b, 5, 1, 4);
        TestAlg.search(b, 2, 1, 4);
        TestAlg.search(b, 10, 1, 4);
    }

    @Test
    public void binary6() {
        int[] data = new int[]{2, 4, 6, 8, 10};
        IntBuffer b = TestAlg.make(data);
        TestAlg.search(b, 6, 3, 3);
        TestAlg.search(b, 5, 3, 3);
        TestAlg.search(b, 50, 3, 3);
    }

    @Test
    public void binary7() {
        int[] data = new int[]{2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8};
        IntBuffer b = TestAlg.make(data);
        int idx = 0;
        idx = Alg.binarySearch(b, 4);
        TestAlg.assertEquals((long)4L, (long)data[idx]);
        idx = Alg.linearSearch(b, 8);
        TestAlg.assertEquals((long)8L, (long)data[idx]);
        TestAlg.search(b, 3);
        TestAlg.search(b, 5);
        TestAlg.search(b, 9);
    }

    private static IntBuffer make(int[] data) {
        ByteBuffer z = ByteBuffer.allocate(4 * data.length);
        z.order(ByteOrder.BIG_ENDIAN);
        IntBuffer x = z.asIntBuffer();
        for (int i = 0; i < data.length; ++i) {
            x.put(i, data[i]);
        }
        return x;
    }

    private static void search(IntBuffer b, int k) {
        int idx1 = Alg.linearSearch(b, k);
        int idx2 = Alg.binarySearch(b, k);
        TestAlg.assertEquals((long)idx1, (long)idx2);
    }

    private static void search(IntBuffer b, int k, int low, int high) {
        int idx1 = Alg.linearSearch(b, low, high, k);
        int idx2 = Alg.binarySearch(b, low, high, k);
        TestAlg.assertEquals((long)idx1, (long)idx2);
    }
}

