/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lib.InternalError;

public class StrUtils {
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNEQUAL = -9;
    public static final int CMP_INDETERMINATE = 2;

    private StrUtils() {
    }

    public static String strjoinNL(String ... args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoinNL(List<String> args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoin(String sep, String ... args) {
        return StrUtils.join(sep, args);
    }

    public static String strjoin(String sep, List<String> args) {
        return StrUtils.join(sep, args);
    }

    private static String join(String sep, String ... a) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return a[0];
        }
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            if (sep != null) {
                sbuff.append(sep);
            }
            sbuff.append(a[i]);
        }
        return sbuff.toString();
    }

    private static String join(String sep, List<String> a) {
        return StrUtils.join(sep, a.toArray(new String[0]));
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalError("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalError("String comparison failure");
    }

    public static byte[] asUTF8bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError("UTF-8 not supported!");
        }
    }

    public static String str(Object x) {
        if (x == null) {
            return "<null>";
        }
        return x.toString();
    }

    public static final boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static final String replace(String string, String target, String replacement) {
        return string.replace(target, replacement);
    }

    public static String substitute(String str, Map<String, String> subs) {
        for (Map.Entry<String, String> e : subs.entrySet()) {
            String param = e.getKey();
            if (!str.contains(param)) continue;
            str = str.replace(param, e.getValue());
        }
        return str;
    }

    public static String strform(Map<String, String> subs, String ... args) {
        return StrUtils.substitute(StrUtils.strjoinNL(args), subs);
    }

    public static String chop(String x) {
        if (x.length() == 0) {
            return x;
        }
        return x.substring(0, x.length() - 1);
    }

    public static List<Character> toCharList(String str) {
        ArrayList<Character> characters = new ArrayList<Character>(str.length());
        char[] arr$ = str.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character ch = Character.valueOf(arr$[i$]);
            characters.add(ch);
        }
        return characters;
    }
}

