/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.hp.hpl.jena.sparql.ARQException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import lib.Pool;

public class PoolFiniteBlocking<T>
implements Pool<T> {
    BlockingDeque<T> pool;

    public PoolFiniteBlocking(int size) {
        this.pool = new LinkedBlockingDeque<T>(size);
    }

    @Override
    public final void put(T item) {
        this.pool.addLast(item);
    }

    @Override
    public T get() {
        try {
            return this.pool.takeFirst();
        }
        catch (InterruptedException ex) {
            throw new ARQException("Failed to get an item from the pool (InterruptedException): " + ex.getMessage());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }
}

