/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.File;
import java.io.FilenameFilter;

public class FileOps {
    private FileOps() {
    }

    public static void delete(String filename) {
        FileOps.delete(new File(filename), true);
    }

    public static void deleteSilent(String filename) {
        FileOps.delete(new File(filename), false);
    }

    public static void delete(File f, boolean reportExistsAfter) {
        try {
            f.delete();
            if (reportExistsAfter && f.exists()) {
                System.err.println("*** Still exists: " + f);
            }
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex);
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void clearDirectory(String dir) {
        try {
            File d = new File(dir);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".*\\..*");
                }
            };
            for (File f : d.listFiles(filter)) {
                FileOps.delete(f, false);
            }
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex);
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

