/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import lib.InternalError;
import lib.Pool;
import lib.PoolSync;

public class Bytes {
    private static final String encodingUTF8 = "utf-8";
    private static Charset utf8 = null;
    private static final int PoolSize = 1;
    private static Pool<CharsetEncoder> encoders = new PoolSync<CharsetEncoder>();
    private static Pool<CharsetDecoder> decoders = new PoolSync<CharsetDecoder>();

    private Bytes() {
    }

    public static void main(String ... args) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        System.out.println("Native order = " + ByteOrder.nativeOrder());
        System.out.println("Default order = " + bb.order());
        System.out.println("Order = " + bb.order());
        bb.asLongBuffer().put(72623859790382856L);
        for (int i = 0; i < bb.capacity(); ++i) {
            System.out.printf("0x%02X ", bb.get(i));
        }
    }

    public static final int getInt(byte[] b) {
        return Bytes.getInt(b, 0);
    }

    public static final int getInt(byte[] b, int idx) {
        return Bytes.assembleInt(b[idx + 0], b[idx + 1], b[idx + 2], b[idx + 3]);
    }

    public static final long getLong(byte[] b) {
        return Bytes.getLong(b, 0);
    }

    public static final long getLong(byte[] b, int idx) {
        return Bytes.assembleLong(b[idx + 0], b[idx + 1], b[idx + 2], b[idx + 3], b[idx + 4], b[idx + 5], b[idx + 6], b[idx + 7]);
    }

    public static final void setInt(int value, byte[] b) {
        Bytes.setInt(value, b, 0);
    }

    public static final void setInt(int x, byte[] b, int idx) {
        b[idx + 0] = (byte)(x >> 24 & 0xFF);
        b[idx + 1] = (byte)(x >> 16 & 0xFF);
        b[idx + 2] = (byte)(x >> 8 & 0xFF);
        b[idx + 3] = (byte)(x & 0xFF);
    }

    public static final void setLong(long value, byte[] b) {
        Bytes.setLong(value, b, 0);
    }

    public static final void setLong(long value, byte[] b, int idx) {
        int lo = (int)(value & 0xFFFFFFFFL);
        int hi = (int)(value >>> 32);
        Bytes.setInt(hi, b, idx);
        Bytes.setInt(lo, b, idx + 4);
    }

    public static byte[] packInt(int val) {
        byte[] valBytes = new byte[4];
        Bytes.setInt(val, valBytes, 0);
        return valBytes;
    }

    public static byte[] packLong(long val) {
        byte[] valBytes = new byte[8];
        Bytes.setLong(val, valBytes, 0);
        return valBytes;
    }

    private static int assembleInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private static Long assembleLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    private static byte byte3(int x) {
        return (byte)(x >> 24);
    }

    private static byte byte2(int x) {
        return (byte)(x >> 16);
    }

    private static byte byte1(int x) {
        return (byte)(x >> 8);
    }

    private static byte byte0(int x) {
        return (byte)(x >> 0);
    }

    public static byte[] string2bytes(String x) {
        try {
            return x.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String bytes2string(byte[] x) {
        try {
            return new String(x, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void toByteBuffer(String s, ByteBuffer bb) {
        CharBuffer cBuff;
        CoderResult r;
        CharsetEncoder enc = encoders.get();
        if (enc == null) {
            enc = utf8.newEncoder();
        }
        if ((r = enc.encode(cBuff = CharBuffer.wrap(s), bb, true)).isOverflow()) {
            throw new InternalError("Bytes.toByteBuffer: encode overflow (1)");
        }
        r = enc.flush(bb);
        if (r.isOverflow()) {
            throw new InternalError("Bytes.toByteBuffer: encode overflow (2)");
        }
        enc.reset();
        encoders.put(enc);
    }

    public static String fromByteBuffer(ByteBuffer bb) {
        if (bb.remaining() == 0) {
            return "";
        }
        try {
            CharsetDecoder dec = decoders.get();
            if (dec == null) {
                dec = utf8.newDecoder();
            }
            CharBuffer cBuff = dec.decode(bb);
            dec.reset();
            decoders.put(dec);
            return cBuff.toString();
        }
        catch (CharacterCodingException ex) {
            throw new InternalError("Bytes:fromByteBuffer: character encoding error in buffer");
        }
    }

    static {
        try {
            utf8 = Charset.forName(encodingUTF8);
            for (int i = 0; i < 1; ++i) {
                encoders.put(utf8.newEncoder());
                decoders.put(utf8.newDecoder());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
    }
}

