/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.PrintStream;
import java.nio.ByteBuffer;

public class ByteBufferLib {
    private ByteBufferLib() {
    }

    public static void fill(ByteBuffer bb, byte v) {
        ByteBufferLib.fill(bb, bb.position(), bb.limit(), v);
    }

    public static void fill(ByteBuffer bb, int start, int finish, byte v) {
        for (int i = start; i < finish; ++i) {
            bb.put(i, v);
        }
    }

    public static void print(ByteBuffer byteBuffer) {
        ByteBufferLib.print(System.out, byteBuffer);
    }

    public static void print(PrintStream out, ByteBuffer byteBuffer) {
        int i;
        out.printf("ByteBuffer[pos=%d lim=%d cap=%d]", byteBuffer.position(), byteBuffer.limit(), byteBuffer.capacity());
        int maxBytes = 72;
        for (i = 0; i < maxBytes && i < byteBuffer.limit(); ++i) {
            if (i % 24 == 0) {
                out.println();
            }
            out.printf(" 0x%02X", byteBuffer.get(i));
        }
        if (i < maxBytes) {
            out.print(" ...");
        }
        out.println();
    }
}

