/*
 * Decompiled with CFR 0.152.
 */
package iterator;

import iterator.IteratorArray;
import java.util.NoSuchElementException;
import org.junit.Test;
import test.BaseTest;

public class TestIteratorArray
extends BaseTest {
    @Test
    public void arrayIterator_1() {
        String[] a = new String[]{};
        IteratorArray<String> iter = IteratorArray.create(a);
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_2() {
        String[] a = new String[]{"a"};
        IteratorArray<String> iter = IteratorArray.create(a);
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_3() {
        String[] a = new String[]{"a", "b", "c"};
        IteratorArray<String> iter = IteratorArray.create(a);
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"b", iter.next());
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"c", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_4() {
        String[] a = new String[]{"a"};
        IteratorArray<String> iter = IteratorArray.create(a);
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        try {
            iter.next();
            TestIteratorArray.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void arrayIterator_5() {
        String[] a = new String[]{"a", "b", "c"};
        IteratorArray<String> iter = IteratorArray.create(a, 0, 1);
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_6() {
        String[] a = new String[]{"a", "b", "c", "d"};
        IteratorArray<String> iter = IteratorArray.create(a, 1, 3);
        TestIteratorArray.assertEquals((Object)"b", iter.next());
        TestIteratorArray.assertEquals((Object)"c", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_7() {
        String[] a = new String[]{"a", "b", "c", "d"};
        IteratorArray<String> iter = IteratorArray.create(a, 1, 3);
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorArray.assertEquals((Object)"c", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }
}

