/*
 * Decompiled with CFR 0.152.
 */
package iterator;

import com.hp.hpl.jena.sparql.util.Utils;
import iterator.ClosableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class RepeatApplyIterator<T>
implements Iterator<T>,
ClosableIterator {
    private Iterator<T> input;
    private boolean finished = false;
    private Iterator<T> currentStage = null;

    protected RepeatApplyIterator(Iterator<T> input) {
        this.input = input;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        while (true) {
            if (this.currentStage == null && this.input.hasNext()) {
                T nextItem = this.input.next();
                this.currentStage = this.makeNextStage(nextItem);
            }
            if (this.currentStage == null) {
                this.finished = true;
                return false;
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage = null;
        }
    }

    protected abstract Iterator<T> makeNextStage(T var1);

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(Utils.className((Object)this) + ".next()/finished");
        }
        return this.currentStage.next();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.input instanceof ClosableIterator) {
            ((ClosableIterator)((Object)this.input)).close();
        }
    }
}

