/*
 * Decompiled with CFR 0.152.
 */
package iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorArray<T>
implements Iterator<T> {
    private int idx;
    private int finishIdx;
    private T[] array;

    public static <T> IteratorArray<T> create(T[] array) {
        return new IteratorArray<T>(array, 0, array.length);
    }

    public static <T> IteratorArray<T> create(T[] array, int start, int finish) {
        return new IteratorArray<T>(array, start, finish);
    }

    private IteratorArray(T[] array, int start, int finish) {
        if (start < 0) {
            throw new IllegalArgumentException("Start: " + start);
        }
        if (start > finish) {
            throw new IllegalArgumentException("Start >= finish: " + start + " >= " + finish);
        }
        this.array = array;
        this.idx = start;
        this.finishIdx = finish;
        if (this.idx < 0) {
            this.idx = 0;
        }
        if (this.finishIdx > array.length) {
            this.finishIdx = array.length;
        }
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.finishIdx;
    }

    public T current() {
        if (this.idx >= this.finishIdx) {
            throw new NoSuchElementException();
        }
        return this.array[this.idx];
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.idx++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ArrayIterator");
    }
}

