/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.Event;
import event.EventListener;
import event.EventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager {
    private static EventManager eventManager = new EventManager();
    private Map<Object, Map<EventType, List<EventListener>>> listeners = new HashMap<Object, Map<EventType, List<EventListener>>>();

    public static void register(Object object, EventType type, EventListener listener) {
        eventManager.register$(object, type, listener);
    }

    public static void unregister(Object object, EventType type, EventListener listener) {
        eventManager.unregister$(object, type, listener);
    }

    public static void send(Object dest, Event event) {
        eventManager.send$(dest, event);
    }

    private EventManager() {
    }

    private void register$(Object object, EventType type, EventListener listener) {
        List<EventListener> z;
        Map<EventType, List<EventListener>> x = this.listeners.get(object);
        if (x == null) {
            x = new HashMap<EventType, List<EventListener>>();
            this.listeners.put(object, x);
        }
        if ((z = x.get((Object)type)) == null) {
            z = new ArrayList<EventListener>();
            x.put(type, z);
        }
        z.add(listener);
    }

    private void unregister$(Object object, EventType type, EventListener listener) {
        List<EventListener> x = this.find(object, type);
        if (x == null) {
            return;
        }
        x.remove(listener);
    }

    private void send$(Object dest, Event event) {
        List<EventListener> x = this.find(dest, event.getType());
        if (x == null) {
            this.deliveryFailure(dest, event);
            return;
        }
        for (EventListener listener : x) {
            listener.event(dest, event);
        }
    }

    private void deliveryFailure(Object object, Event event) {
    }

    private List<EventListener> find(Object object, EventType type) {
        Map<EventType, List<EventListener>> x = this.listeners.get(object);
        if (x == null) {
            return null;
        }
        List<EventListener> z = x.get((Object)type);
        return z;
    }
}

