/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.index.IndexType;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTDB {
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final String TDB_NS = "http://jena.hpl.hp.com/TDB#";
    public static final int SizeOfLong = 8;
    public static final int SizeOfInt = 4;
    public static final int SizeOfNodeId = 8;
    public static final int SizeOfPointer = 4;
    public static final int LenIndexTripleRecord = 24;
    public static final int LenIndexQuadRecord = 32;
    public static final int LenNodeHash = 8;
    public static final String symbolNamespace = "http://jena.hpl.hp.com/TDB#";
    public static final String tdbSymbolPrefix = "tdb";
    public static final String tdbPropertyRoot = "com.hp.hpl.jena.tdb";
    public static final Symbol symLogDuplicates = SystemTDB.allocSymbol("logDuplicates");
    public static final Symbol symFileMode = SystemTDB.allocSymbol("fileMode");
    public static final Symbol symIndexType = SystemTDB.allocSymbol("indexType");
    private static final String propertyFileKey1 = "com.hp.hpl.jena.tdb.settings";
    private static final String propertyFileKey2 = "tdb:settings";
    private static String propertyFileName = null;
    private static Properties properties;
    public static final int BlockSize = 8192;
    public static final int BlockSizeTest = 1024;
    public static final int OrderMem = 5;
    public static final int SegmentSize;
    public static final int Node2NodeIdCacheSize;
    public static final int NodeId2NodeCacheSize;
    public static final int BlockWriteCacheSize;
    public static final int BlockReadCacheSize;
    public static final int SyncTick;
    public static ReorderTransformation defaultOptimizer;
    public static final ByteOrder NetworkOrder;
    public static boolean NullOut;
    public static boolean Checking;
    public static final int BDB_cacheSizePercent;
    public static final boolean is64bitSystem;
    private static FileMode fileMode;
    public static final String indexTypeBTree = "BTree";
    public static final String indexTypeBPlusTree = "BPlusTree";
    public static final String indexTypeExtHash = "ExtHash";
    public static final String defaultIndexType = "BPlusTree";
    private static IndexType indexType;

    public static void panic(Class<?> clazz, String string) {
        LoggerFactory.getLogger(clazz).error(string);
        throw new TDBException(string);
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith(tdbSymbolPrefix)) {
            throw new TDBException("Symbol short name begins with the TDB namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new TDBException("Symbol short name begins with http: " + shortName);
        }
        return SystemTDB.allocSymbol("http://jena.hpl.hp.com/TDB#", shortName);
    }

    private static Symbol allocSymbol(String namespace, String shortName) {
        return Symbol.create((String)(namespace + shortName));
    }

    private static int intValue(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        if (name.length() == 0) {
            throw new TDBException("Empty string for value name");
        }
        if (properties == null) {
            return defaultValue;
        }
        String x = properties.getProperty(name);
        if (x == null) {
            return defaultValue;
        }
        TDB.logInfo.info("Set: " + name + " = " + x);
        int v = Integer.parseInt(x);
        return v;
    }

    private static Properties readPropertiesFile() {
        if (propertyFileName == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            BufferedReader r = FileUtils.asBufferedUTF8((InputStream)new FileInputStream(propertyFileName));
            p.load(r);
            TDB.logInfo.info("Using properties from '" + propertyFileName + "'");
        }
        catch (FileNotFoundException ex) {
            log.debug("No system properties file (" + propertyFileName + ")");
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return p;
    }

    private static boolean determineIf64Bit() {
        String s = System.getProperty("sun.arch.data.model");
        if (s != null) {
            boolean b = s.equals("64");
            TDB.logInfo.debug("System architecture: " + (b ? "64 bit" : "32 bit"));
            return b;
        }
        s = System.getProperty("java.vm.info");
        if (s == null) {
            log.warn("Can't determine the data model");
            return false;
        }
        log.debug("Can't determine the data model from 'sun.arch.data.model' - using java.vm.info");
        boolean b = s.contains("64");
        TDB.logInfo.debug("System architecture: (from java.vm.info) " + (b ? "64 bit" : "32 bit"));
        return b;
    }

    public static FileMode fileMode() {
        if (fileMode == null) {
            fileMode = SystemTDB.determineFileMode();
        }
        return fileMode;
    }

    public static void setFileMode(FileMode newFileMode) {
        if (fileMode != null) {
            log.warn("System file mode already determined - setting it has no effect");
            return;
        }
        fileMode = newFileMode;
    }

    private static FileMode determineFileMode() {
        String x = ARQ.getContext().getAsString(symFileMode, "default");
        if (x.equalsIgnoreCase("direct")) {
            TDB.logInfo.info("File mode: direct (forced)");
            return FileMode.direct;
        }
        if (x.equalsIgnoreCase("mapped")) {
            TDB.logInfo.info("File mode: mapped (forced)");
            return FileMode.mapped;
        }
        if (x.equalsIgnoreCase("default")) {
            if (is64bitSystem) {
                TDB.logInfo.debug("File mode: Mapped");
                return FileMode.mapped;
            }
            TDB.logInfo.debug("File mode: Direct");
            return FileMode.direct;
        }
        throw new TDBException("Unrecognized file mode (not one of 'default', 'direct' or 'mapped': " + x);
    }

    public static IndexType getIndexType() {
        if (indexType != null) {
            return indexType;
        }
        boolean defaultSetting = false;
        String x = TDB.getContext().getAsString(symIndexType);
        if (x == null) {
            defaultSetting = true;
            x = "BPlusTree";
        }
        IndexType iType = IndexType.get(x);
        if (!defaultSetting) {
            LoggerFactory.getLogger(IndexType.class).info("Index type: " + (Object)((Object)iType));
        }
        indexType = iType;
        return iType;
    }

    static {
        propertyFileName = System.getProperty(propertyFileKey1);
        if (propertyFileName == null) {
            propertyFileName = System.getProperty(propertyFileKey2);
        }
        properties = SystemTDB.readPropertiesFile();
        SegmentSize = SystemTDB.intValue("SegmentSize", 0x800000);
        Node2NodeIdCacheSize = SystemTDB.intValue("Node2NodeIdCacheSize", 100000);
        NodeId2NodeCacheSize = SystemTDB.intValue("NodeId2NodeCacheSize", 100000);
        BlockWriteCacheSize = SystemTDB.intValue("BlockWriteCacheSize", 2000);
        BlockReadCacheSize = SystemTDB.intValue("BlockReadCacheSize", 10000);
        SyncTick = SystemTDB.intValue("SyncTick", 100000);
        defaultOptimizer = null;
        NetworkOrder = ByteOrder.BIG_ENDIAN;
        NullOut = false;
        Checking = false;
        BDB_cacheSizePercent = SystemTDB.intValue("BDB_cacheSizePercent", 75);
        is64bitSystem = SystemTDB.determineIf64Bit();
        fileMode = null;
        indexType = null;
    }
}

