/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.NullIterator;
import iterator.Transform;
import java.util.Iterator;
import lib.Tuple;

public class TripleTable
implements Sync,
Closeable {
    final NodeTupleTable table;
    private static Transform<Tuple<Node>, Triple> action = new Transform<Tuple<Node>, Triple>(){

        @Override
        public Triple convert(Tuple<Node> item) {
            return new Triple(item.get(0), item.get(1), item.get(2));
        }
    };

    public TripleTable(TupleIndex[] indexes, RecordFactory indexRecordFactory, NodeTable nodeTable, Location location) {
        this.table = new NodeTupleTable(3, indexes, nodeTable);
    }

    public boolean add(Triple triple) {
        return this.table.addRow(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Triple triple) {
        return this.table.deleteRow(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(s, p, o);
        if (iter == null) {
            return new NullIterator<Triple>();
        }
        Iterator<Triple> iter2 = TupleLib.convertToTriples(this.table.getNodeTable(), iter);
        return iter2;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.table;
    }

    @Override
    public void sync(boolean force) {
        this.table.sync(force);
    }

    public void close() {
        this.table.close();
    }
}

