/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.tdb.store.NodeId;
import junit.TestBase;
import org.junit.Test;

public class TestNodeId
extends TestBase {
    @Test
    public void nodeId_01() {
        NodeId nodeId = NodeId.create(37L);
        TestNodeId.assertEquals((long)37L, (long)nodeId.getId());
    }

    @Test
    public void nodeId_02() {
        NodeId nodeId = NodeId.create(-1L);
        TestNodeId.assertEquals((long)-1L, (long)nodeId.getId());
    }

    @Test
    public void nodeId_int_1() {
        this.test("1", SSE.parseNode((String)"1"));
    }

    @Test
    public void nodeId_int_2() {
        this.test("2", SSE.parseNode((String)"2"));
    }

    @Test
    public void nodeId_int_3() {
        this.test("'3'^^xsd:int", SSE.parseNode((String)"3"));
    }

    @Test
    public void nodeId_int_4() {
        this.test("'3'", null);
    }

    @Test
    public void nodeId_int_5() {
        this.test("-1", SSE.parseNode((String)"-1"));
    }

    @Test
    public void nodeId_int_6() {
        this.test("-180", SSE.parseNode((String)"-180"));
    }

    @Test
    public void nodeId_int_7() {
        this.test("01", SSE.parseNode((String)"1"));
    }

    @Test
    public void nodeId_int_8() {
        this.test("+01", SSE.parseNode((String)"1"));
    }

    @Test
    public void nodeId_decimal_1() {
        this.test("3.14", SSE.parseNode((String)"3.14"));
    }

    @Test
    public void nodeId_decimal_2() {
        this.test("123456789.123456789", null);
    }

    @Test
    public void nodeId_decimal_3() {
        this.test("12.89", Node.createLiteral((String)"12.89", null, (RDFDatatype)XSDDatatype.XSDdecimal));
    }

    @Test
    public void nodeId_decimal_4() {
        this.test("-1.0", SSE.parseNode((String)"-1.0"));
    }

    @Test
    public void nodeId_dateTime_1() {
        this.test("'2008-04-28T15:36:15+01:00'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:15+01:00'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_2() {
        this.test("'2008-04-28T15:36:15Z'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:15Z'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_3() {
        this.test("'2008-04-28T15:36:15+00:00'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:15+00:00'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_4() {
        this.test("'2008-04-28T15:36:15-05:00'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:15-05:00'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_5() {
        this.test("'2008-04-28T15:36:15'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:15'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_6() {
        this.test("'2008-04-28T15:36:05.450'^^xsd:dateTime", SSE.parseNode((String)"'2008-04-28T15:36:05.450'^^xsd:dateTime"));
    }

    @Test
    public void nodeId_dateTime_8() {
        this.test("'8008-04-28T15:36:05.450'^^xsd:dateTime", null);
    }

    @Test
    public void nodeId_date_1() {
        this.test("'2008-04-28Z'^^xsd:date", SSE.parseNode((String)"'2008-04-28Z'^^xsd:date"));
    }

    @Test
    public void nodeId_date_2() {
        this.test("'2008-04-28+00:00'^^xsd:date", SSE.parseNode((String)"'2008-04-28+00:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_3() {
        this.test("'2008-04-28-05:00'^^xsd:date", SSE.parseNode((String)"'2008-04-28-05:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_4() {
        this.test("'2008-04-28+02:00'^^xsd:date", SSE.parseNode((String)"'2008-04-28+02:00'^^xsd:date"));
    }

    @Test
    public void nodeId_date_5() {
        this.test("'8008-04-28'^^xsd:date", null);
    }

    @Test
    public void nodeId_boolean_1() {
        this.test("'true'^^xsd:boolean", SSE.parseNode((String)"'true'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_2() {
        this.test("'false'^^xsd:boolean", SSE.parseNode((String)"'false'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_3() {
        this.test("'1'^^xsd:boolean", SSE.parseNode((String)"'true'^^xsd:boolean"));
    }

    @Test
    public void nodeId_boolean_4() {
        this.test("'0'^^xsd:boolean", SSE.parseNode((String)"'false'^^xsd:boolean"));
    }

    private void test(String x, Node correct) {
        Node n = SSE.parseNode((String)x);
        NodeId nodeId = NodeId.inline(n);
        if (correct == null) {
            TestNodeId.assertNull((Object)nodeId);
            return;
        }
        Node n2 = NodeId.extract(nodeId);
        TestNodeId.assertNotNull((Object)n2);
        TestNodeId.assertEquals((Object)correct, (Object)n2);
    }
}

