/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.util.FileManager;
import org.junit.Test;
import test.BaseTest;

public class TestDataset
extends BaseTest {
    private static String base1 = "http://example/";
    private static String baseNS = "http://example/ns#";
    static String defaultGraph = Quad.defaultGraphIRI.getURI();
    static String unionGraph = Quad.unionGraph.getURI();

    private static Dataset create() {
        return TDBFactory.createDataset();
    }

    private static void load(Model model, String file) {
        FileManager.get().readModel(model, file);
    }

    private static void load1(Model model) {
        model.setNsPrefix("", base1);
        Resource r1 = model.createResource(base1 + "r1");
        Property p1 = model.createProperty(baseNS + "p1");
        model.add(r1, p1, "x1");
        model.add(r1, p1, "x2");
    }

    private static void load2(Model model) {
        Resource r1 = model.createResource(base1 + "r2");
        Property p1 = model.createProperty(baseNS + "p1");
        model.add(r1, p1, "x1");
        model.add(r1, p1, "x2");
    }

    private static void load3(Model model) {
        Resource r1 = model.createResource(base1 + "r3");
        Property p1 = model.createProperty(baseNS + "p2");
        model.add(r1, p1, "x1");
        model.add(r1, p1, "x2");
    }

    @Test
    public void prefix1() {
        Dataset ds = TestDataset.create();
        Model m = ds.getDefaultModel();
        TestDataset.load1(m);
        String x = m.expandPrefix(":x");
        TestDataset.assertEquals((Object)x, (Object)(base1 + "x"));
    }

    @Test
    public void prefix2() {
        Dataset ds = TestDataset.create();
        Model m = ds.getDefaultModel();
        TestDataset.load1(m);
        Model m2 = ds.getNamedModel("http://example/graph/");
        String x = m2.expandPrefix(":x");
        TestDataset.assertEquals((Object)x, (Object)":x");
    }

    @Test
    public void query1() {
        Dataset ds = TestDataset.create();
        Model m = ds.getDefaultModel();
        TestDataset.load1(m);
        String qs = "CONSTRUCT {?s ?p ?o } WHERE {?s ?p ?o}";
        Query q = QueryFactory.create((String)qs);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)ds);
        Model m2 = qExec.execConstruct();
        TestDataset.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void query2() {
        Dataset ds = TestDataset.create();
        Model m = ds.getDefaultModel();
        TestDataset.load1(m);
        String qs = "CONSTRUCT {?s ?p ?o } WHERE { GRAPH <http://example/graph/> {?s ?p ?o}}";
        Query q = QueryFactory.create((String)qs);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)ds);
        Model m2 = qExec.execConstruct();
        TestDataset.assertTrue((boolean)m2.isEmpty());
    }

    @Test
    public void special1() {
        Dataset ds = TestDataset.create();
        Model m = ds.getDefaultModel();
        TestDataset.load1(m);
        String qs = "CONSTRUCT {?s ?p ?o } WHERE { GRAPH <" + defaultGraph + "> {?s ?p ?o}}";
        Query q = QueryFactory.create((String)qs);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)ds);
        Model m2 = qExec.execConstruct();
        TestDataset.assertTrue((boolean)m.isIsomorphicWith(m2));
    }

    @Test
    public void special2() {
        Dataset ds = TestDataset.create();
        TestDataset.load1(ds.getDefaultModel());
        TestDataset.load2(ds.getNamedModel("http://example/graph1"));
        TestDataset.load3(ds.getNamedModel("http://example/graph2"));
        Model m = ModelFactory.createDefaultModel();
        TestDataset.load2(m);
        TestDataset.load3(m);
        String qs = "CONSTRUCT {?s ?p ?o } WHERE { GRAPH <" + unionGraph + "> {?s ?p ?o}}";
        Query q = QueryFactory.create((String)qs);
        QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Dataset)ds);
        Model m2 = qExec.execConstruct();
        TestDataset.assertTrue((boolean)m.isIsomorphicWith(m2));
    }
}

