/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.NullIterator;
import iterator.Transform;
import java.util.Iterator;
import lib.Tuple;

public class QuadTable
implements Sync,
Closeable {
    final NodeTupleTable table;
    private static Transform<Tuple<Node>, Quad> action = new Transform<Tuple<Node>, Quad>(){

        @Override
        public Quad convert(Tuple<Node> item) {
            return new Quad(item.get(0), item.get(1), item.get(2), item.get(3));
        }
    };

    public QuadTable(TupleIndex[] indexes, RecordFactory indexRecordFactory, NodeTable nodeTable, Location location) {
        this.table = new NodeTupleTable(4, indexes, nodeTable);
    }

    public boolean add(Quad quad) {
        return this.table.addRow(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean add(Node gn, Triple triple) {
        return this.table.addRow(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Quad quad) {
        return this.table.deleteRow(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean delete(Node gn, Triple triple) {
        return this.table.deleteRow(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(g, s, p, o);
        if (iter == null) {
            return new NullIterator<Quad>();
        }
        Iterator<Quad> iter2 = TupleLib.convertToQuads(this.table.getNodeTable(), iter);
        return iter2;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.table;
    }

    @Override
    public void sync(boolean force) {
        this.table.sync(force);
    }

    public void close() {
        this.table.close();
    }
}

