/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.GraphSyncListener;
import com.hp.hpl.jena.tdb.graph.UpdateListener;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.DatasetPrefixes;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTriplesTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphTriplesTDB.class);
    private final TripleTable tripleTable;
    private final DatasetPrefixes prefixes;

    public GraphTriplesTDB(TripleTable tripleTable, DatasetPrefixes prefixes, ReorderTransformation reorderTransform, Location location) {
        super(reorderTransform, location);
        this.tripleTable = tripleTable;
        this.prefixes = prefixes;
        int syncPoint = SystemTDB.SyncTick;
        if (syncPoint > 0) {
            this.getEventManager().register((GraphListener)new GraphSyncListener(this, syncPoint));
        }
        this.getEventManager().register((GraphListener)new UpdateListener(this));
    }

    @Override
    public void performAdd(Triple t) {
        boolean changed = this.tripleTable.add(t);
        if (!changed) {
            this.duplicate(t);
        }
    }

    private void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && log.isInfoEnabled()) {
            String $ = FmtUtils.stringForTriple((Triple)t, (PrefixMapping)this.getPrefixMapping());
            log.info("Duplicate: (" + $ + ")");
        }
    }

    @Override
    public void performDelete(Triple t) {
        boolean changed = this.tripleTable.delete(t);
    }

    @Override
    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        Iterator<Triple> iter = this.tripleTable.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iter == null) {
            return new NullIterator();
        }
        return new GraphTDBBase.MapperIteratorTriples(iter);
    }

    @Override
    public Tuple<Node> asTuple(Triple triple) {
        return Tuple.create(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        return this.tripleTable.getNodeTupleTable().getTupleTable().getIndex(0).all();
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        return this.tripleTable.getNodeTupleTable();
    }

    @Override
    public final Node getGraphNode() {
        return null;
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return this.prefixes.getPrefixMapping();
    }

    @Override
    public final void close() {
        this.tripleTable.close();
        super.close();
    }

    @Override
    public void sync(boolean force) {
        this.prefixes.sync(force);
        this.tripleTable.sync(force);
    }
}

