/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.BulkUpdateHandlerTDB;
import com.hp.hpl.jena.tdb.graph.GraphBase2;
import com.hp.hpl.jena.tdb.graph.QueryHandlerTDB;
import com.hp.hpl.jena.tdb.graph.Reifier2;
import com.hp.hpl.jena.tdb.graph.TransactionHandlerTDB;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import iterator.Iter;
import java.util.Iterator;

public abstract class GraphTDBBase
extends GraphBase2
implements GraphTDB {
    private final QueryHandlerTDB queryHandler = new QueryHandlerTDB(this);
    private final TransactionHandler transactionHandler = new TransactionHandlerTDB(this);
    private final BulkUpdateHandler bulkUpdateHandler = new BulkUpdateHandlerTDB(this);
    private final ReorderTransformation reorderTransform;
    private final Location location;

    public GraphTDBBase(ReorderTransformation transformation, Location location) {
        this.reorderTransform = transformation;
        this.location = location;
    }

    @Override
    public final ReorderTransformation getReorderTransform() {
        return this.reorderTransform;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    protected Reifier constructReifier() {
        return new Reifier2(this);
    }

    protected abstract Iterator<?> countThis();

    @Override
    protected final int graphBaseSize() {
        Iterator<?> iter = this.countThis();
        return (int)Iter.count(iter);
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulkUpdateHandler;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                public boolean sizeAccurate() {
                    return true;
                }

                public boolean addAllowed() {
                    return true;
                }

                public boolean addAllowed(boolean every) {
                    return true;
                }

                public boolean deleteAllowed() {
                    return true;
                }

                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                public boolean canBeEmpty() {
                    return true;
                }

                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                public boolean findContractSafe() {
                    return true;
                }

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    @Override
    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    static class MapperIteratorQuads
    extends NiceIterator {
        private final Iterator<Quad> iter;
        private final Node graphNode;

        MapperIteratorQuads(Node graphNode, Iterator<Quad> iter) {
            this.graphNode = graphNode;
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Triple next() {
            Quad q = this.iter.next();
            if (!q.getGraph().equals((Object)this.graphNode)) {
                throw new InternalError("GraphNamed: Quads from unexpected graph");
            }
            return q.getTriple();
        }

        public void remove() {
            this.iter.remove();
        }
    }

    static class MapperIteratorTriples
    extends NiceIterator {
        private final Iterator<Triple> iter;

        MapperIteratorTriples(Iterator<Triple> iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Triple next() {
            return this.iter.next();
        }

        public void remove() {
            this.iter.remove();
        }
    }
}

