/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.graph.GraphSyncListener;
import com.hp.hpl.jena.tdb.graph.UpdateListener;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphNamedTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphNamedTDB.class);
    private final DatasetGraphTDB dataset;
    private final QuadTable quadTable;
    private final Node graphNode;
    private NodeId graphNodeId = null;
    private final ReorderTransformation transform;

    public GraphNamedTDB(DatasetGraphTDB dataset, Node graphName, ReorderTransformation transform) {
        super(transform, dataset.getLocation());
        this.dataset = dataset;
        this.quadTable = dataset.getQuadTable();
        this.graphNode = graphName;
        this.transform = transform;
        if (graphName == null) {
            throw new TDBException("GraphNamedTDB: Null graph name");
        }
        if (!graphName.isURI()) {
            throw new TDBException("GraphNamedTDB: Graph name not a URI");
        }
        int syncPoint = SystemTDB.SyncTick;
        if (syncPoint > 0) {
            this.getEventManager().register((GraphListener)new GraphSyncListener(this, syncPoint));
        }
        this.getEventManager().register((GraphListener)new UpdateListener(this));
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return this.dataset.getPrefixes().getPrefixMapping(this.graphNode.getURI());
    }

    @Override
    public void performAdd(Triple t) {
        boolean changed = this.dataset.getQuadTable().add(this.graphNode, t);
        if (!changed) {
            this.duplicate(t);
        }
    }

    private void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && log.isInfoEnabled()) {
            String $ = FmtUtils.stringForTriple((Triple)t, (PrefixMapping)this.getPrefixMapping());
            log.info("Duplicate: (" + $ + ")");
        }
    }

    @Override
    public void performDelete(Triple t) {
        boolean changed = this.dataset.getQuadTable().delete(this.graphNode, t);
    }

    @Override
    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        Iterator<Quad> iter = this.dataset.getQuadTable().find(this.graphNode, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iter == null) {
            return new NullIterator();
        }
        return new GraphTDBBase.MapperIteratorQuads(this.graphNode, iter);
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        NodeId gn = this.getGraphNodeId();
        Tuple<NodeId> t = Tuple.create(gn, null, null, null);
        Iterator<Tuple<NodeId>> iter = this.dataset.getQuadTable().getNodeTupleTable().getTupleTable().find(t);
        return iter;
    }

    @Override
    public final Node getGraphNode() {
        return this.graphNode;
    }

    public final NodeId getGraphNodeId() {
        if (this.graphNodeId == null) {
            this.graphNodeId = this.dataset.getQuadTable().getNodeTupleTable().getNodeTable().getNodeIdForNode(this.graphNode);
        }
        return this.graphNodeId;
    }

    @Override
    public Tuple<Node> asTuple(Triple triple) {
        return Tuple.create(this.getGraphNode(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        if (this.graphNode == null) {
            return this.dataset.getDefaultTripleTableTable().getNodeTupleTable();
        }
        return this.dataset.getQuadTable().getNodeTupleTable();
    }

    public final DatasetGraphTDB getDataset() {
        return this.dataset;
    }

    @Override
    public final void close() {
        this.dataset.close();
        super.close();
    }

    @Override
    public void sync(boolean force) {
        this.dataset.getPrefixes().sync(force);
        this.dataset.sync(force);
    }
}

