/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixes;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import lib.ColumnMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryGraphTDB {
    private static Logger log = LoggerFactory.getLogger(FactoryGraphTDB.class);
    public static final RecordFactory indexRecordTripleFactory = new RecordFactory(24, 0);
    public static final RecordFactory indexRecordQuadFactory = new RecordFactory(32, 0);
    public static final RecordFactory nodeRecordFactory = new RecordFactory(8, 8);

    public static GraphTriplesTDB createGraph(Location location) {
        return FactoryGraphTDB.createGraph(IndexBuilder.get(), location);
    }

    public static GraphTriplesTDB createGraph(IndexBuilder indexBuilder, Location location) {
        return FactoryGraphTDB._createGraph(indexBuilder, location);
    }

    public static GraphTriplesTDB createGraphMem() {
        return FactoryGraphTDB.createGraphMem(IndexBuilder.mem());
    }

    public static GraphTriplesTDB createGraphMem(IndexBuilder indexBuilder) {
        return FactoryGraphTDB.createGraph(indexBuilder, null);
    }

    public static Model createModel(Location location) {
        return ModelFactory.createModelForGraph((Graph)FactoryGraphTDB.createGraph(location));
    }

    public static DatasetGraph createDatasetGraph(Location location) {
        return FactoryGraphTDB.createDatasetGraph(IndexBuilder.get(), location, Names.tripleIndexes, Names.quadIndexes);
    }

    public static DatasetGraph createDatasetGraphMem() {
        return FactoryGraphTDB.createDatasetGraph(IndexBuilder.mem(), null, Names.tripleIndexes, Names.quadIndexes);
    }

    public static DatasetGraph createDatasetGraph(IndexBuilder indexBuilder, Location location, String[] graphDesc, String[] quadDesc) {
        return FactoryGraphTDB._createDatasetGraph(indexBuilder, location, graphDesc, quadDesc);
    }

    public static Dataset createDataset(Location location) {
        return new DatasetImpl(FactoryGraphTDB.createDatasetGraph(location));
    }

    public static Dataset createDatasetMem() {
        return new DatasetImpl(FactoryGraphTDB.createDatasetGraphMem());
    }

    public static TupleIndex[] indexes(IndexBuilder indexBuilder, RecordFactory recordFactory, Location location, String primary, String ... descs) {
        TupleIndex[] indexes = new TupleIndex[descs.length];
        int i = 0;
        for (String desc : descs) {
            indexes[i] = FactoryGraphTDB.createTupleIndex(indexBuilder, recordFactory, location, primary, desc);
            ++i;
        }
        return indexes;
    }

    static TripleTable createTripleTableMem() {
        NodeTable nodeTable = NodeTableFactory.createMem(IndexBuilder.mem());
        return FactoryGraphTDB.createTripleTable(IndexBuilder.mem(), nodeTable, null, Names.tripleIndexes);
    }

    public static TripleTable createTripleTable(IndexBuilder indexBuilder, NodeTable nodeTable, Location location, String ... descs) {
        TupleIndex[] indexes = FactoryGraphTDB.indexes(indexBuilder, indexRecordTripleFactory, location, "SPO", descs);
        return new TripleTable(indexes, indexRecordTripleFactory, nodeTable, location);
    }

    private static GraphTriplesTDB _createGraph(IndexBuilder indexBuilder, Location location) {
        NodeTable nodeTable = NodeTableFactory.create(indexBuilder, location);
        TripleTable table = FactoryGraphTDB.createTripleTable(indexBuilder, nodeTable, location, Names.tripleIndexes);
        ReorderTransformation transform = FactoryGraphTDB.chooseOptimizer(location);
        DatasetPrefixes prefixes = new DatasetPrefixes(indexBuilder, location);
        return new GraphTriplesTDB(table, prefixes, transform, location);
    }

    private static DatasetGraph _createDatasetGraph(IndexBuilder indexBuilder, Location location, String[] graphDesc, String[] quadDesc) {
        NodeTable nodeTable = NodeTableFactory.create(indexBuilder, location);
        TripleTable triples = FactoryGraphTDB.createTripleTable(indexBuilder, nodeTable, location, graphDesc);
        QuadTable quads = FactoryGraphTDB.createQuadTable(indexBuilder, nodeTable, location, quadDesc);
        DatasetPrefixes prefixes = new DatasetPrefixes(indexBuilder, location);
        return new DatasetGraphTDB(triples, quads, prefixes, FactoryGraphTDB.chooseOptimizer(location), location);
    }

    static QuadTable createQuadTableMem() {
        NodeTable nodeTable = NodeTableFactory.createMem(IndexBuilder.mem());
        return FactoryGraphTDB.createQuadTable(IndexBuilder.mem(), nodeTable, null, Names.tripleIndexes);
    }

    private static QuadTable createQuadTable(IndexBuilder indexBuilder, NodeTable nodeTable, Location location, String ... descs) {
        TupleIndex[] indexes = FactoryGraphTDB.indexes(indexBuilder, indexRecordQuadFactory, location, "GSPO", descs);
        return new QuadTable(indexes, indexRecordQuadFactory, nodeTable, location);
    }

    private static TupleIndex createTupleIndex(IndexBuilder indexBuilder, RecordFactory recordFactory, Location location, String primary, String desc) {
        RangeIndex rIdx1 = indexBuilder.newRangeIndex(location, recordFactory, desc);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(desc.length(), new ColumnMap(primary, desc), recordFactory, rIdx1);
        return tupleIndex;
    }

    private static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted(location.getPath("stats.opt"));
                TDB.logInfo.info("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            TDB.logInfo.info("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            TDB.logInfo.info("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultOptimizer;
        }
        if (reorder == null) {
            TDB.logExec.warn("No BGP optimizer");
        }
        return reorder;
    }
}

