/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.tdb.TDBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import lib.BitsInt;
import lib.BitsLong;

public class DateTimeNode {
    static final int DATE_LEN = 22;
    static final int TIME_LEN = 27;
    static final int MILLI = 0;
    static final int MILLI_LEN = 16;
    static final int MINUTES = 16;
    static final int MINUTES_LEN = 6;
    static final int HOUR = 22;
    static final int HOUR_LEN = 5;
    static final int DAY = 27;
    static final int DAY_LEN = 5;
    static final int MONTH = 32;
    static final int MONTH_LEN = 4;
    static final int YEAR = 36;
    static final int YEAR_LEN = 13;
    static final int TZ = 49;
    static final int TZ_LEN = 7;
    static final int TZ_Z = 127;
    static final int TZ_NONE = 126;
    static DatatypeFactory datatypeFactory = null;

    static long time(long v, int hour, int mins, int millisec) {
        v = BitsLong.pack(v, hour, 22, 27);
        v = BitsLong.pack(v, mins, 16, 22);
        v = BitsLong.pack(v, millisec, 0, 16);
        return v;
    }

    static long date(long v, int year, int month, int day) {
        v = BitsLong.pack(v, year, 36, 49);
        v = BitsLong.pack(v, month, 32, 36);
        v = BitsLong.pack(v, day, 27, 32);
        return v;
    }

    static long tz(long v, int tz_in_quarters) {
        v = BitsLong.pack(v, tz_in_quarters, 49, 56);
        return v;
    }

    public static long packDate(String lex) {
        return DateTimeNode.packDateTime(lex);
    }

    public static long packDateTime(String lex) {
        long v = 0L;
        boolean containsZ = lex.indexOf(90) > 0;
        XMLGregorianCalendar xcal = datatypeFactory.newXMLGregorianCalendar(lex);
        int y = xcal.getYear();
        if (y < 0 || y >= 8000) {
            return -1L;
        }
        v = DateTimeNode.date(v, xcal.getYear(), xcal.getMonth(), xcal.getDay());
        v = DateTimeNode.time(v, xcal.getHour(), xcal.getMinute(), xcal.getSecond() * 1000 + xcal.getMillisecond());
        if (containsZ) {
            return DateTimeNode.tz(v, 127);
        }
        int tz = xcal.getTimezone();
        if (tz == Integer.MIN_VALUE) {
            return DateTimeNode.tz(v, 126);
        }
        if (tz % 15 != 0) {
            return -1L;
        }
        return DateTimeNode.tz(v, tz /= 15);
    }

    public static String unpackDateTime(long v) {
        return DateTimeNode.unpack(v, true);
    }

    public static String unpackDate(long v) {
        return DateTimeNode.unpack(v, false);
    }

    private static String unpack(long v, boolean isDateTime) {
        int tz;
        String lex;
        int years = (int)BitsLong.unpack(v, 36, 49);
        int months = (int)BitsLong.unpack(v, 32, 36);
        int days = (int)BitsLong.unpack(v, 27, 32);
        int hours = (int)BitsLong.unpack(v, 22, 27);
        int minutes = (int)BitsLong.unpack(v, 16, 22);
        int milliSeconds = (int)BitsLong.unpack(v, 0, 16);
        int sec = milliSeconds / 1000;
        int fractionSec = milliSeconds % 1000;
        String string = lex = isDateTime ? String.format("%04d-%02d-%02dT%02d:%02d:%02d", years, months, days, hours, minutes, sec) : String.format("%04d-%02d-%02d", years, months, days);
        if (isDateTime && fractionSec != 0) {
            lex = String.format("%s.%d", lex, fractionSec);
        }
        if ((tz = (int)BitsLong.unpack(v, 49, 56)) == 127) {
            return lex + "Z";
        }
        if (tz == 126) {
            return lex;
        }
        if (BitsLong.isSet(v, 55)) {
            tz = BitsInt.set(tz, 7, 32);
        }
        int tzH = tz / 4;
        int tzM = tz % 4 * 15;
        return String.format("%s%+03d:%02d", lex, tzH, tzM);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new TDBException("DateTimeNode", ex);
        }
    }
}

