/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lib.ColumnMap;
import lib.Tuple;

public class DatasetPrefixes
implements Closeable,
Sync {
    static final String unamedGraphURI = "";
    private final NodeTupleTable nodeTupleTable;
    static final ColumnMap colMap = new ColumnMap("GPU", "GPU");
    static final RecordFactory factory = new RecordFactory(24, 0);

    public DatasetPrefixes(Location location) {
        this(IndexBuilder.get(), location);
    }

    public DatasetPrefixes(IndexBuilder indexBuilder, Location location) {
        TupleIndexRecord index = new TupleIndexRecord(3, colMap, factory, indexBuilder.newRangeIndex(location, factory, "prefixIdx"));
        TupleIndex[] indexes = new TupleIndex[]{index};
        NodeTable nodes = NodeTableFactory.create(indexBuilder, location, "prefixes.dat", "prefix2id", -1, -1);
        this.nodeTupleTable = new NodeTupleTable(3, indexes, nodes);
    }

    private DatasetPrefixes() {
        TupleIndexRecord index = new TupleIndexRecord(3, colMap, factory, IndexBuilder.mem().newRangeIndex(null, factory, "prefixIdx"));
        TupleIndex[] indexes = new TupleIndex[]{index};
        NodeTable nodes = NodeTableFactory.create(IndexBuilder.mem(), null, "prefixes.dat", "prefix2id", -1, -1);
        this.nodeTupleTable = new NodeTupleTable(3, indexes, nodes);
    }

    public static DatasetPrefixes testing() {
        return new DatasetPrefixes();
    }

    public synchronized void insertPrefix(String graphName, String prefix, String uri) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Node u = Node.createURI((String)uri);
        this.nodeTupleTable.addRow(g, p, u);
    }

    public Set<String> graphNames() {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(new Node[]{null, null, null});
        HashSet<String> x = new HashSet<String>();
        while (iter.hasNext()) {
            x.add(iter.next().get(0).getURI());
        }
        return x;
    }

    public synchronized String readPrefix(String graphName, String prefix) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        if (!iter.hasNext()) {
            return null;
        }
        Node uri = iter.next().get(2);
        return uri.getURI();
    }

    public synchronized String readByURI(String graphName, String uriStr) {
        Node g = Node.createURI((String)graphName);
        Node u = Node.createURI((String)uriStr);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, u);
        if (!iter.hasNext()) {
            return null;
        }
        Node prefix = iter.next().get(1);
        return prefix.getLiteralLexicalForm();
    }

    public synchronized Map<String, String> readPrefixMap(String graphName) {
        Node g = Node.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        HashMap<String, String> map = new HashMap<String, String>();
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = t.get(1).getLiteralLexicalForm();
            String uri = t.get(2).getURI();
            map.put(prefix, uri);
        }
        return map;
    }

    public synchronized void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        Node g = Node.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = t.get(1).getLiteralLexicalForm();
            String uri = t.get(2).getURI();
            pmap.setNsPrefix(prefix, uri);
        }
    }

    public synchronized void removeFromPrefixMap(String graphName, String prefix, String uri) {
        Node g = Node.createURI((String)graphName);
        Node p = Node.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        while (iter.hasNext()) {
            this.nodeTupleTable.deleteRow(g, p, iter.next().get(2));
        }
    }

    public void close() {
        this.nodeTupleTable.close();
    }

    @Override
    public void sync(boolean force) {
        this.nodeTupleTable.sync(force);
    }

    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(unamedGraphURI);
    }

    public PrefixMapping getPrefixMapping(String graphName) {
        return new Projection(graphName);
    }

    class Projection
    extends PrefixMappingImpl {
        private String graphName;

        Projection(String graphName) {
            this.graphName = graphName;
        }

        public String getNsURIPrefix(String uri) {
            String x = super.getNsURIPrefix(uri);
            if (x != null) {
                return x;
            }
            x = DatasetPrefixes.this.readByURI(this.graphName, uri);
            if (x != null) {
                super.set(x, uri);
            }
            return x;
        }

        public Map<String, String> getNsPrefixMap() {
            Map<String, String> m = DatasetPrefixes.this.readPrefixMap(this.graphName);
            for (Map.Entry<String, String> e : m.entrySet()) {
                super.set(e.getKey(), e.getValue());
            }
            return m;
        }

        protected void set(String prefix, String uri) {
            super.set(prefix, uri);
            DatasetPrefixes.this.insertPrefix(this.graphName, prefix, uri);
        }

        protected String get(String prefix) {
            String x = super.get(prefix);
            if (x != null) {
                return x;
            }
            x = DatasetPrefixes.this.readPrefix(this.graphName, prefix);
            super.set(prefix, x);
            return x;
        }

        public PrefixMapping removeNsPrefix(String prefix) {
            String uri = super.getNsPrefixURI(prefix);
            if (uri != null) {
                DatasetPrefixes.this.removeFromPrefixMap(this.graphName, prefix, uri);
            }
            super.removeNsPrefix(prefix);
            return this;
        }
    }
}

