/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.DatasetPrefixes;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import iterator.Iter;
import iterator.Transform;
import java.util.Iterator;
import lib.Tuple;

public class DatasetGraphTDB
implements DatasetGraph,
Sync,
Closeable {
    private final TripleTable tripleTable;
    private final QuadTable quadTable;
    private final GraphTriplesTDB defaultGraph;
    private final DatasetPrefixes prefixes;
    private final Lock lock = new LockMRSW();
    private final ReorderTransformation transform;
    private static Transform<Tuple<NodeId>, NodeId> project0 = new Transform<Tuple<NodeId>, NodeId>(){

        @Override
        public NodeId convert(Tuple<NodeId> item) {
            return item.get(0);
        }
    };

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixes prefixes, ReorderTransformation transform, Location location) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.transform = transform;
        this.prefixes = prefixes;
        this.defaultGraph = new GraphTriplesTDB(tripleTable, prefixes, transform, location);
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getDefaultTripleTableTable() {
        return this.tripleTable;
    }

    public boolean containsGraph(Node graphNode) {
        NodeId graphNodeId = this.quadTable.getNodeTupleTable().getNodeTable().getNodeIdForNode(graphNode);
        Tuple<NodeId> pattern = Tuple.create(graphNodeId, null, null, null);
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().find(pattern);
        boolean result = x.hasNext();
        return result;
    }

    public GraphTDB getDefaultGraph() {
        return this.defaultGraph;
    }

    public GraphTDB getGraph(Node graphNode) {
        return new GraphNamedTDB(this, graphNode, this.transform);
    }

    public Lock getLock() {
        return this.lock;
    }

    public ReorderTransformation getTransform() {
        return this.transform;
    }

    public DatasetPrefixes getPrefixes() {
        return this.prefixes;
    }

    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().getIndex(0).all();
        Iter<NodeId> z = Iter.iter(x).map(project0).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), z);
    }

    public int size() {
        return (int)Iter.count(this.listGraphNodes());
    }

    public Location getLocation() {
        return this.defaultGraph.getLocation();
    }

    @Override
    public void sync(boolean force) {
        this.tripleTable.sync(force);
        this.quadTable.sync(force);
        this.prefixes.sync(force);
    }

    public void close() {
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
    }
}

