/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphListenerBase;
import com.hp.hpl.jena.sparql.util.graph.GraphLoadMonitor;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import lib.ArrayUtils;
import lib.MapUtils;
import lib.Tuple;

public class BulkLoader {
    private GraphTDB graph;
    private Symbol symTesting = SystemTDB.allocSymbol("testing");
    private boolean testingSpecial = false;
    private boolean showProgress;
    private boolean doInParallel = false;
    private boolean doIncremental = false;
    private boolean doInterleaved = false;
    private boolean generateStats = false;
    private int numIndexes;
    private TupleIndex primaryIndex;
    private TupleIndex[] secondaryIndexes;
    private Item statsItem = null;
    private NodeTupleTable nodeTupleTable;
    GraphStatsCollector statsMonitor = new GraphStatsCollector();
    public static int LoadTickPoint = 50000;
    public static long IndexTickPoint = 100000L;
    private static long quantum2 = 5L * IndexTickPoint;
    private static Object lock = new Object();

    public static void load(GraphTDB graph, List<String> urls, boolean showProgress) {
        BulkLoader loader = new BulkLoader(graph, showProgress);
        loader.load(urls);
    }

    public BulkLoader(GraphTDB graph, boolean showProgress) {
        this(graph, showProgress, false, false, false);
    }

    public BulkLoader(GraphTDB graph, boolean showProgress, boolean doInParallel, boolean doIncremental, boolean generateStats) {
        this.graph = graph;
        this.nodeTupleTable = graph.getNodeTupleTable();
        if (this.nodeTupleTable.getTupleTable().getTupleLen() != 3) {
            throw new TDBException("BulkLoader: Bulk mode only works on 3-tuples");
        }
        this.showProgress = showProgress;
        this.doInParallel = doInParallel;
        this.doIncremental = doIncremental;
        this.generateStats = generateStats;
        this.testingSpecial = TDB.getContext().isTrue(this.symTesting);
    }

    public void load(List<String> urls) {
        boolean rebuildIndexes;
        Model model = ModelFactory.createModelForGraph((Graph)this.graph);
        boolean bl = rebuildIndexes = !this.doIncremental;
        if (!this.graph.isEmpty()) {
            rebuildIndexes = false;
        }
        if (rebuildIndexes) {
            this.println("** Load empty graph");
            this.dropSecondaryIndexes();
            if (this.testingSpecial) {
                this.println("** Load node table only");
                this.nodeTupleTable.getTupleTable().setTupleIndex(0, null);
            }
        } else {
            this.println("** Load graph with existing data");
            this.generateStats = false;
        }
        Timer timer = new Timer();
        timer.startTimer();
        long count = 0L;
        for (String url : urls) {
            this.statsStart(model);
            this.now("-- Start data phase");
            count += BulkLoader.loadOne(model, url, this.showProgress);
            this.now("-- Finish data phase");
            this.statsFinish(model);
        }
        if (this.generateStats && this.statsItem != null) {
            String fn = this.graph.getLocation().getPath("stats.opt");
            try {
                FileOutputStream fout = new FileOutputStream(fn);
                IndentedWriter out = new IndentedWriter((OutputStream)fout);
                ItemWriter.write((IndentedWriter)out, (Item)this.statsItem, null);
                out.ensureStartOfLine();
                out.flush();
                fout.close();
            }
            catch (IOException ex) {
                ALog.fatal((Object)this, (String)("Failed to write stats file: " + ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
        this.graph.sync(true);
        if (this.testingSpecial) {
            this.graph.close();
            return;
        }
        this.println();
        if (rebuildIndexes) {
            this.now("-- Start index phase");
            if (this.showProgress) {
                this.println("** Secondary indexes");
            }
            this.createSecondaryIndexes(this.showProgress);
            this.now("-- Finish index phase");
        }
        if (this.showProgress) {
            this.println("** Close graph");
        }
        this.graph.close();
        timer.endTimer();
        long time = timer.getTimeInterval();
        if (this.showProgress) {
            long tps = 1000L * count / time;
            this.println();
            this.printf("Time for load: %.2fs [%,d triples/s]\n", (double)time / 1000.0, tps);
        }
    }

    private void statsStart(Model model) {
        if (this.generateStats) {
            model.getGraph().getEventManager().register((GraphListener)this.statsMonitor);
        }
    }

    private void statsFinish(Model model) {
        if (this.generateStats) {
            model.getGraph().getEventManager().unregister((GraphListener)this.statsMonitor);
            this.statsItem = StatsCollector.format(this.statsMonitor.predicates, this.statsMonitor.count);
        }
    }

    private static long loadOne(Model model, String s, boolean showProgress) {
        GraphLoadMonitor monitor = new GraphLoadMonitor(LoadTickPoint, false);
        if (showProgress) {
            model.getGraph().getEventManager().register((GraphListener)monitor);
        }
        if (!s.equals("-")) {
            FileManager.get().readModel(model, s);
        } else {
            model.read(System.in, null, "N-TRIPLES");
        }
        if (showProgress) {
            model.getGraph().getEventManager().unregister((GraphListener)monitor);
        }
        return showProgress ? monitor.getAddCount() : -1L;
    }

    private <T> T[] copy(T[] array) {
        Object[] array2 = new Object[array.length];
        System.arraycopy(array, 0, array2, 0, array.length);
        return array2;
    }

    private void dropSecondaryIndexes() {
        this.numIndexes = this.nodeTupleTable.getTupleTable().numIndexes();
        this.primaryIndex = this.nodeTupleTable.getTupleTable().getIndex(0);
        this.secondaryIndexes = ArrayUtils.alloc(TupleIndex.class, this.numIndexes - 1);
        System.arraycopy(this.nodeTupleTable.getTupleTable().getIndexes(), 1, this.secondaryIndexes, 0, this.numIndexes - 1);
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, null);
        }
    }

    private void createSecondaryIndexes(boolean printTiming) {
        if (this.doInParallel) {
            this.createSecondaryIndexesParallel(printTiming);
        } else if (this.doInterleaved) {
            this.createSecondaryIndexesInterleaved(printTiming);
        } else {
            this.createSecondaryIndexesSequential(printTiming);
        }
        for (int i = 1; i < this.numIndexes; ++i) {
            this.nodeTupleTable.getTupleTable().setTupleIndex(i, this.secondaryIndexes[i - 1]);
        }
    }

    private void createSecondaryIndexesParallel(boolean printTiming) {
        this.println("** Parallel index building");
        Timer timer = new Timer();
        timer.startTimer();
        TupleIndex primary = this.nodeTupleTable.getTupleTable().getIndex(0);
        int semaCount = 0;
        Semaphore sema = new Semaphore(0);
        for (TupleIndex index : this.secondaryIndexes) {
            if (index == null) continue;
            Runnable builder = this.setup(sema, primary, index, index.getLabel(), printTiming);
            new Thread(builder).start();
            ++semaCount;
        }
        try {
            sema.acquire(semaCount);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        long time = timer.readTimer();
        timer.endTimer();
        if (printTiming) {
            this.printf("Time for parallel indexing: %.2fs\n", (double)time / 1000.0);
        }
    }

    private Runnable setup(final Semaphore sema, final TupleIndex srcIndex, final TupleIndex destIndex, final String label, final boolean printTiming) {
        Runnable builder = new Runnable(){

            @Override
            public void run() {
                BulkLoader.this.copyIndex(srcIndex.all(), new TupleIndex[]{destIndex}, label, printTiming);
                sema.release();
            }
        };
        return builder;
    }

    private void createSecondaryIndexesSequential(boolean printTiming) {
        Timer timer = new Timer();
        timer.startTimer();
        TupleIndex primary = this.nodeTupleTable.getTupleTable().getIndex(0);
        for (TupleIndex index : this.secondaryIndexes) {
            if (index == null) continue;
            long time1 = timer.readTimer();
            this.copyIndex(primary.all(), new TupleIndex[]{index}, index.getLabel(), printTiming);
            long time2 = timer.readTimer();
            if (!printTiming) continue;
            this.println();
        }
    }

    private void createSecondaryIndexesInterleaved(boolean printTiming) {
        Timer timer = new Timer();
        timer.startTimer();
        long time1 = timer.readTimer();
        this.copyIndex(this.primaryIndex.all(), this.secondaryIndexes, "All", printTiming);
        long time2 = timer.readTimer();
        if (printTiming) {
            this.printf("Time for all indexes: %.2fs\n", (double)(time2 - time1) / 1000.0);
        }
    }

    private void copyIndex(Iterator<Tuple<NodeId>> srcIter, TupleIndex[] destIndexes, String label, boolean printTiming) {
        Timer timer = new Timer();
        long cumulative = 0L;
        long c = 0L;
        long last = 0L;
        timer.startTimer();
        int counter = 0;
        while (srcIter.hasNext()) {
            Tuple<NodeId> tuple = srcIter.next();
            for (TupleIndex destIdx : destIndexes) {
                if (destIdx == null) continue;
                destIdx.add(tuple);
            }
            ++c;
            if (printTiming && BulkLoader.tickPoint(++cumulative, IndexTickPoint)) {
                long t = timer.readTimer();
                long batchTime = t - last;
                long elapsed = t;
                last = t;
                this.printf("Index %s: %,d slots (Batch: %,d slots/s / Run: %,d slots/s)\n", label, cumulative, 1000L * c / batchTime, 1000L * cumulative / elapsed);
                if (BulkLoader.tickPoint(cumulative, quantum2)) {
                    String timestamp = Utils.nowAsString();
                    String x = StringUtils.str((float)((float)elapsed / 1000.0f));
                    this.printf("  Elapsed: %s seconds [%s]\n", x, timestamp);
                }
                c = 0L;
            }
            ++counter;
        }
        for (TupleIndex destIdx : destIndexes) {
            if (destIdx == null) continue;
            destIdx.sync(true);
        }
        long totalTime = timer.endTimer();
        if (printTiming) {
            if (cumulative > 0L) {
                if (totalTime > 0L) {
                    this.printf("Index %s: %,d triples indexed in %,.2fs [%,d slots/s]\n", label, cumulative, (double)totalTime / 1000.0, 1000L * cumulative / totalTime);
                } else {
                    this.printf("Index %s: %,d triples indexed in %,.2fs\n", label, cumulative, (double)totalTime / 1000.0);
                }
            } else {
                this.printf("Index %s: 0 triples indexed\n", label);
            }
        }
    }

    private static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }

    private synchronized void printf(String fmt, Object ... args) {
        if (!this.showProgress) {
            return;
        }
        System.out.printf(fmt, args);
    }

    private synchronized void println() {
        if (!this.showProgress) {
            return;
        }
        System.out.println();
    }

    private synchronized void println(String str) {
        if (!this.showProgress) {
            return;
        }
        System.out.println(str);
    }

    private synchronized void now(String str) {
        if (!this.showProgress) {
            return;
        }
        if (str != null) {
            System.out.print(str);
            System.out.print(" : ");
        }
        System.out.println(StringUtils.str((Date)new Date()));
    }

    public static void loadSimple(Model model, List<String> urls, boolean showProgress) {
        Timer timer = new Timer();
        timer.startTimer();
        long count = 0L;
        for (String s : urls) {
            if (showProgress) {
                System.out.printf("Load: %s\n", s);
            }
            count += BulkLoader.loadOne(model, s, showProgress);
        }
        model.close();
    }

    static class GraphStatsCollector
    extends GraphListenerBase {
        Map<Node, Integer> predicates = new HashMap<Node, Integer>();
        long count = 0L;

        GraphStatsCollector() {
        }

        protected void addEvent(Triple t) {
            MapUtils.increment(this.predicates, t.getPredicate());
            ++this.count;
        }

        protected void deleteEvent(Triple t) {
        }
    }
}

