/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.stats;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.Printable;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.lib.NodeConst;
import com.hp.hpl.jena.tdb.solver.reorder.PatternElements;
import com.hp.hpl.jena.tdb.solver.reorder.PatternTriple;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib.NotImplemented;

public final class StatsMatcher {
    public static final String STATS = "stats";
    public static final String META = "meta";
    public static final String COUNT = "count";
    List<Pattern> patterns = new ArrayList<Pattern>();
    Map<Item, List<Pattern>> _patterns = new HashMap<Item, List<Pattern>>();
    long count = -1L;
    static final double weightSP = 2.0;
    static final double weightPO = 10.0;
    static final double weightTypeO = 1000.0;
    static final double weightSP_small = 2.0;
    static final double weightPO_small = 4.0;
    static final double weightTypeO_small = 40.0;

    public StatsMatcher() {
    }

    public StatsMatcher(String filename) {
        Item stats = SSE.readFile((String)filename);
        if (stats.isNil()) {
            ALog.warn((Object)this, (String)("Empty stats file: " + filename));
            return;
        }
        if (!stats.isTagged(STATS)) {
            throw new TDBException("Not a stats file: " + filename);
        }
        this.init(stats);
    }

    public StatsMatcher(Item stats) {
        this.init(stats);
    }

    private void init(Item stats) {
        if (!stats.isTagged(STATS)) {
            throw new TDBException("Not a tagged 'stats'");
        }
        ItemList list = stats.getList().cdr();
        if (list.car().isTagged(META)) {
            Item elt1 = list.car();
            list = list.cdr();
            Item x = Item.find((ItemList)elt1.getList(), (String)COUNT);
            if (x != null) {
                this.count = x.getList().get(1).asInteger();
            }
        }
        while (!list.isEmpty()) {
            Item elt = list.car();
            list = list.cdr();
            Item pat = elt.getList().get(0);
            if (pat.isNode()) {
                double numProp = elt.getList().get(1).getDouble();
                if (this.count < 100L) {
                    this.addPatternsSmall(pat, numProp);
                    continue;
                }
                this.addPatterns(pat, numProp);
                continue;
            }
            Item w = elt.getList().get(1);
            Pattern pattern = new Pattern(((Number)w.getNode().getLiteralValue()).doubleValue(), this.intern(pat.getList().get(0)), this.intern(pat.getList().get(1)), this.intern(pat.getList().get(2)));
            this.addPattern(pattern);
        }
    }

    public void addPatterns(Node predicate, double numProp) {
        this.addPatterns(Item.createNode((Node)predicate), numProp);
    }

    public void addPatternsSmall(Node predicate, double numProp) {
        this.addPatternsSmall(Item.createNode((Node)predicate), numProp);
    }

    private void addPatterns(Item predicate, double numProp) {
        double wSP = 2.0;
        double wPO = 10.0;
        if (NodeConst.nodeRDFType.equals((Object)predicate.getNode())) {
            wPO = 1000.0;
        }
        this.addPatterns(predicate, numProp, wSP, wPO);
    }

    private void addPatternsSmall(Item predicate, double numProp) {
        double wSP = 2.0;
        double wPO = 4.0;
        if (NodeConst.nodeRDFType.equals((Object)predicate.getNode())) {
            wPO = 40.0;
        }
        this.addPatterns(predicate, numProp, wSP, wPO);
    }

    private void addPatterns(Item predicate, double wP, double wSP, double wPO) {
        this.addPattern(new Pattern(wSP, PatternElements.TERM, predicate, PatternElements.ANY));
        this.addPattern(new Pattern(wPO, PatternElements.ANY, predicate, PatternElements.TERM));
        this.addPattern(new Pattern(wP, PatternElements.ANY, predicate, PatternElements.ANY));
    }

    public void addPattern(Pattern pattern) {
        StatsMatcher.check(pattern);
        this.patterns.add(pattern);
        List<Pattern> entry = this._patterns.get(pattern.predItem);
        if (entry == null) {
            entry = new ArrayList<Pattern>();
            this._patterns.put(pattern.predItem, entry);
        }
        entry.add(pattern);
    }

    public void addPattern(Triple triple) {
        if (triple.getSubject().isVariable()) {
            // empty if block
        }
        throw new NotImplemented("StatsMatcher.addPattern");
    }

    private static void check(Pattern pattern) {
        StatsMatcher.check(pattern.subjItem);
        StatsMatcher.check(pattern.predItem);
        StatsMatcher.check(pattern.objItem);
    }

    private static void check(Item item) {
        if (Var.isVar((Node)item.getNode())) {
            throw new TDBException("Explicit variable used in a pattern (use VAR): " + item.getNode());
        }
    }

    private Item intern(Item item) {
        if (item.sameSymbol(PatternElements.ANY.getSymbol())) {
            return PatternElements.ANY;
        }
        if (item.sameSymbol(PatternElements.VAR.getSymbol())) {
            return PatternElements.VAR;
        }
        if (item.sameSymbol(PatternElements.TERM.getSymbol())) {
            return PatternElements.TERM;
        }
        if (item.sameSymbol(PatternElements.URI.getSymbol())) {
            return PatternElements.URI;
        }
        if (item.sameSymbol(PatternElements.LITERAL.getSymbol())) {
            return PatternElements.LITERAL;
        }
        if (item.sameSymbol(PatternElements.BNODE.getSymbol())) {
            return PatternElements.BNODE;
        }
        return item;
    }

    public double match(Triple t) {
        return this.match(Item.createNode((Node)t.getSubject()), Item.createNode((Node)t.getPredicate()), Item.createNode((Node)t.getObject()));
    }

    public double match(PatternTriple pTriple) {
        return this.match(pTriple.subject, pTriple.predicate, pTriple.object);
    }

    public double match(Item subj, Item pred, Item obj) {
        if (PatternElements.isSet(subj) && PatternElements.isSet(pred) && PatternElements.isSet(obj)) {
            return 1.0;
        }
        if (pred.isNodeURI()) {
            double w = -1.0;
            w = this.search(pred, subj, pred, obj, w);
            w = this.search(PatternElements.TERM, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.isVar()) {
            double w = -1.0;
            w = this.search(PatternElements.VAR, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.equals((Object)PatternElements.TERM)) {
            double w = -1.0;
            w = this.search(PatternElements.TERM, subj, pred, obj, w);
            w = this.search(PatternElements.ANY, subj, pred, obj, w);
            return w;
        }
        if (pred.equals((Object)PatternElements.ANY)) {
            throw new TDBException("Predicate is ANY");
        }
        throw new TDBException("Unidentified predicate: " + pred + " in (" + subj + " " + pred + " " + obj + ")");
    }

    private double search(Item key, Item subj, Item pred, Item obj, double oldMin) {
        List<Pattern> entry = this._patterns.get(key);
        if (entry == null) {
            return oldMin;
        }
        double w = StatsMatcher.matchLinear(entry, subj, pred, obj);
        return StatsMatcher.minPos(w, oldMin);
    }

    private static double minPos(double x, double y) {
        if (x == -1.0) {
            return y;
        }
        if (y == -1.0) {
            return x;
        }
        return Math.min(x, y);
    }

    private static double matchLinear(List<Pattern> patterns, Item subj, Item pred, Item obj) {
        for (Pattern pattern : patterns) {
            Match match = new Match();
            if (!StatsMatcher.matchNode(subj, pattern.subjItem, match) || !StatsMatcher.matchNode(pred, pattern.predItem, match) || !StatsMatcher.matchNode(obj, pattern.objItem, match)) continue;
            return pattern.weight;
        }
        return -1.0;
    }

    private static boolean matchNode(Item node, Item item, Match details) {
        if (PatternElements.isAny(item)) {
            ++details.anyMatches;
            return true;
        }
        if (PatternElements.isAnyVar(item)) {
            ++details.varMatches;
            return true;
        }
        if (node.isSymbol()) {
            if (node.equals((Object)PatternElements.TERM)) {
                if (item.equals((Object)PatternElements.TERM)) {
                    ++details.termMatches;
                    return true;
                }
                return false;
            }
            throw new TDBException("StatsMatcher: unexpected slot type: " + node);
        }
        if (!node.isNode()) {
            return false;
        }
        Node n = node.getNode();
        if (n.isConcrete()) {
            if (item.isNode() && item.getNode().equals((Object)n)) {
                ++details.exactMatches;
                return true;
            }
            if (PatternElements.isAnyTerm(item)) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyURI(item) && n.isURI()) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyLiteral(item) && n.isLiteral()) {
                ++details.termMatches;
                return true;
            }
            if (PatternElements.isAnyBNode(item) && n.isBlank()) {
                ++details.termMatches;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String $ = "";
        for (Pattern p : this.patterns) {
            $ = $ + p + "\n";
        }
        return $;
    }

    public void printSSE(PrintStream ps) {
        IndentedWriter out = new IndentedWriter((OutputStream)ps);
        out.println((Object)"(stats");
        out.incIndent();
        for (Pattern p : this.patterns) {
            p.output(out);
            out.println();
        }
        out.decIndent();
        out.println((Object)")");
        out.flush();
    }

    private static class Match {
        double weight = -1.0;
        int exactMatches = 0;
        int termMatches = 0;
        int varMatches = 0;
        int anyMatches = 0;

        private Match() {
        }
    }

    public static class Pattern
    implements Printable {
        Item subjItem;
        Item predItem;
        Item objItem;
        double weight;

        public Pattern(double w, Item subj, Item pred, Item obj) {
            this.weight = w;
            this.subjItem = subj;
            this.predItem = pred;
            this.objItem = obj;
        }

        public String toString() {
            return PrintUtils.toString((Printable)this);
        }

        public void output(IndentedWriter out) {
            out.print((Object)"(");
            out.print((Object)"(");
            out.print((Object)this.subjItem.toString());
            out.print((Object)" ");
            out.print((Object)this.predItem.toString());
            out.print((Object)" ");
            out.print((Object)this.objItem.toString());
            out.print((Object)")");
            out.print((Object)" ");
            out.print((Object)this.weight);
            out.print((Object)")");
        }
    }
}

