/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver.reorder;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.solver.reorder.PatternElements;
import com.hp.hpl.jena.tdb.solver.reorder.PatternTriple;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderProc;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderProcIndexes;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import iterator.Iter;
import iterator.Transform;
import java.util.ArrayList;
import java.util.List;

public abstract class ReorderTransformationBase
implements ReorderTransformation {
    protected static final boolean DEBUG = false;
    private static Transform<Triple, PatternTriple> convert = new Transform<Triple, PatternTriple>(){

        @Override
        public PatternTriple convert(Triple triple) {
            return new PatternTriple(triple);
        }
    };

    @Override
    public BasicPattern reorder(BasicPattern pattern) {
        return this.reorderIndexes(pattern).reorder(pattern);
    }

    @Override
    public final ReorderProc reorderIndexes(BasicPattern pattern) {
        if (pattern.size() <= 1) {
            return ReorderLib.identityProc();
        }
        List triples = pattern.getList();
        List<PatternTriple> components = Iter.toList(Iter.map(triples, convert));
        components = this.modifyComponents(components);
        ReorderProc proc = this.reorder(triples, components);
        return proc;
    }

    protected List<PatternTriple> modifyComponents(List<PatternTriple> components) {
        return components;
    }

    private ReorderProc reorder(List<Triple> triples, List<PatternTriple> components) {
        int j;
        int idx;
        int N;
        int numReorder = N = components.size();
        int[] indexes = new int[N];
        for (idx = 0; idx < numReorder && (j = this.chooseNext(components)) >= 0; ++idx) {
            Triple triple = triples.get(j);
            indexes[idx] = j;
            ReorderTransformationBase.update(triple, components);
            components.set(j, null);
        }
        for (int i = 0; i < components.size(); ++i) {
            if (components.get(i) == null) continue;
            indexes[idx++] = i;
        }
        if (triples.size() != idx) {
            throw new TDBException(String.format("Inconsistency: number of triples (%d) not equal to number of indexes processed (%d)", triples.size(), idx));
        }
        ReorderProcIndexes proc = new ReorderProcIndexes(indexes);
        return proc;
    }

    protected int chooseNext(List<PatternTriple> pTriples) {
        int idx = this.processPTriples(pTriples, null);
        return idx;
    }

    protected List<Integer> chooseAll(List<PatternTriple> pTriples) {
        ArrayList<Integer> results = new ArrayList<Integer>(pTriples.size());
        this.processPTriples(pTriples, results);
        return results;
    }

    private int processPTriples(List<PatternTriple> pTriples, List<Integer> results) {
        double min = Double.MAX_VALUE;
        int N = pTriples.size();
        int idx = -1;
        for (int i = 0; i < N; ++i) {
            PatternTriple pt = pTriples.get(i);
            if (pt == null) continue;
            double x = this.weight(pt);
            if (x < 0.0) {
                if (idx != -1) continue;
                idx = i;
                if (results == null) continue;
                results.add(i);
                continue;
            }
            if (x == min) {
                if (results == null) continue;
                results.add(i);
                continue;
            }
            if (!(x < min)) continue;
            min = x;
            idx = i;
            if (results == null) continue;
            results.clear();
            results.add(i);
        }
        return idx;
    }

    protected abstract double weight(PatternTriple var1);

    protected static void update(Triple triple, List<PatternTriple> components) {
        for (PatternTriple elt : components) {
            if (elt == null) continue;
            ReorderTransformationBase.update(triple, elt);
        }
    }

    private static void update(Triple triple, PatternTriple tuple) {
        ReorderTransformationBase.update(triple.getSubject(), tuple);
        ReorderTransformationBase.update(triple.getPredicate(), tuple);
        ReorderTransformationBase.update(triple.getObject(), tuple);
    }

    private static void update(Node node, PatternTriple elt) {
        if (Var.isVar((Node)node)) {
            if (node.equals((Object)elt.subject.getNode())) {
                elt.subject = PatternElements.TERM;
            }
            if (node.equals((Object)elt.predicate.getNode())) {
                elt.predicate = PatternElements.TERM;
            }
            if (node.equals((Object)elt.object.getNode())) {
                elt.object = PatternElements.TERM;
            }
        }
    }

    protected static void update(Var var, Node value, List<PatternTriple> components) {
        for (PatternTriple elt : components) {
            if (elt == null) continue;
            ReorderTransformationBase.update(var, value, elt);
        }
    }

    private static void update(Var var, Node value, PatternTriple elt) {
        if (var.equals((Object)elt.subject.getNode())) {
            elt.subject = Item.createNode((Node)value);
        }
        if (var.equals((Object)elt.predicate.getNode())) {
            elt.predicate = Item.createNode((Node)value);
        }
        if (var.equals((Object)elt.object.getNode())) {
            elt.object = Item.createNode((Node)value);
        }
    }
}

