/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.tdb.pgraph.PGraphFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import iterator.Iter;
import java.util.ArrayList;
import java.util.List;
import junit.TestBase;
import lib.StrUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSolverTDB
extends TestBase {
    static final String graphData = "testing/data.ttl";
    static Graph graph = null;
    static PrefixMapping pmap = null;

    @BeforeClass
    public static void beforeClass() {
        graph = PGraphFactory.createMem();
        Model m = ModelFactory.createModelForGraph((Graph)graph);
        FileManager.get().readModel(m, graphData);
        pmap = new PrefixMappingImpl();
        pmap.setNsPrefix("", "http://example/");
    }

    private static void addAll(Graph srcGraph, Graph dstGraph) {
        ExtendedIterator triples = srcGraph.find(Node.ANY, Node.ANY, Node.ANY);
        for (Triple t : Iter.iter(triples)) {
            dstGraph.add(t);
        }
    }

    @Test
    public void solve_01() {
        ResultSet rs1 = TestSolverTDB.exec("(bgp (:s :p :o))", graph);
        ResultSet rs2 = TestSolverTDB.results("unit");
        TestSolverTDB.equals(rs1, rs2);
    }

    @Test
    public void solve_02() {
        ResultSet rs1 = TestSolverTDB.exec("(bgp (:s :p :o2))", graph);
        ResultSet rs2 = TestSolverTDB.results("empty");
        TestSolverTDB.equals(rs1, rs2);
    }

    @Test
    public void solve_03() {
        ResultSet rs1 = TestSolverTDB.exec("(bgp (:zzzz :p 999999))", graph);
        ResultSet rs2 = TestSolverTDB.results("empty");
        TestSolverTDB.equals(rs1, rs2);
    }

    @Test
    public void solve_04() {
        ResultSet rs1 = TestSolverTDB.exec("(bgp (:a :p :a))", graph);
        ResultSet rs2 = TestSolverTDB.results("empty");
        TestSolverTDB.equals(rs1, rs2);
    }

    @Test
    public void solve_05() {
        ResultSet rs1 = TestSolverTDB.exec("(project (?s ?y) (bgp (?s :p ?z) (?z :q ?y)))", graph);
        ResultSet rs2 = TestSolverTDB.results("(row (?s :s) (?y :y))");
        TestSolverTDB.equals(rs1, rs2);
    }

    @Test
    public void solve_06() {
        ResultSet rs1 = TestSolverTDB.exec("(bgp (:s ?p ?o))", graph);
        ResultSet rs2 = TestSolverTDB.results("(row (?p :p) (?o :o))", "(row (?p :p) (?o 10))", "(row (?p :p) (?o :x))");
        TestSolverTDB.equals(rs1, rs2);
    }

    private static void equals(ResultSet rs1, ResultSet rs2) {
        TestSolverTDB.same(rs1, rs2, true);
    }

    private static void same(ResultSet rs1, ResultSet rs2, boolean result) {
        ResultSetRewindable rsw2;
        ResultSetRewindable rsw1 = ResultSetFactory.makeRewindable((ResultSet)rs1);
        boolean b = ResultSetUtils.equals((ResultSet)rsw1, (ResultSet)(rsw2 = ResultSetFactory.makeRewindable((ResultSet)rs2)));
        if (b != result) {
            System.out.println("Different: ");
            rsw1.reset();
            rsw2.reset();
            ResultSetFormatter.out((ResultSet)rsw1);
            ResultSetFormatter.out((ResultSet)rsw2);
            System.out.println();
        }
        TestSolverTDB.assertTrue((b == result ? 1 : 0) != 0);
    }

    private static ResultSet results(String ... rows) {
        String str = "(table " + StrUtils.strjoin("", rows) + ")";
        return SSE.parseTable((String)str).toResultSet();
    }

    private static ResultSet exec(String pattern, Graph graph) {
        Op op = SSE.parseOp((String)pattern, (PrefixMapping)pmap);
        ArrayList vars = new ArrayList();
        vars.addAll(OpVars.allVars((Op)op));
        QueryIterator qIter = Algebra.exec((Op)op, (Graph)graph);
        return ResultSetFactory.create((QueryIterator)qIter, vars);
    }

    private static List<Binding> toList(QueryIterator qIter) {
        ArrayList<Binding> x = new ArrayList<Binding>();
        while (qIter.hasNext()) {
            x.add(qIter.nextBinding());
        }
        return x;
    }
}

