/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.tdb.solver.TestSolverLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderProcIndexes;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderWeighted;
import com.hp.hpl.jena.tdb.solver.stats.StatsMatcher;
import org.junit.Test;
import test.BaseTest;

public class TestReorder
extends BaseTest {
    @Test
    public void match_01() {
        StatsMatcher matcher = TestSolverLib.matcher("((:x :p ANY) 5)");
        Triple t = TestSolverLib.triple("(:x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_02() {
        StatsMatcher matcher = TestSolverLib.matcher("((:x :p ANY) 5)");
        Triple t = TestSolverLib.triple("(:x :q ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_03() {
        StatsMatcher matcher = TestSolverLib.matcher("((:x :p VAR) 5)");
        Triple t = TestSolverLib.triple("(:x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_04() {
        StatsMatcher matcher = TestSolverLib.matcher("((TERM :p VAR) 5)");
        Triple t = TestSolverLib.triple("(:x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_05() {
        StatsMatcher matcher = TestSolverLib.matcher("((URI :p VAR) 5)");
        Triple t = TestSolverLib.triple("(:x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_06() {
        StatsMatcher matcher = TestSolverLib.matcher("((LITERAL :p VAR) 5)");
        Triple t = TestSolverLib.triple("(:x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_07() {
        StatsMatcher matcher = TestSolverLib.matcher("((BNODE :p VAR) 5)");
        Triple t = TestSolverLib.triple("(_:a :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_08() {
        StatsMatcher matcher = TestSolverLib.matcher("((VAR :p LITERAL) 5)");
        Triple t = TestSolverLib.triple("(?x :p ?v)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)-1.0, (double)d, (double)0.0);
    }

    @Test
    public void match_09() {
        StatsMatcher matcher = TestSolverLib.matcher("((VAR :p LITERAL) 5)");
        Triple t = TestSolverLib.triple("(?x :p 1913)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_10() {
        StatsMatcher matcher = TestSolverLib.matcher("((VAR :p LITERAL) 5) ((VAR :p ANY) 10)");
        Triple t = TestSolverLib.triple("(?x :p 1913)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)5.0, (double)d, (double)0.0);
    }

    @Test
    public void match_11() {
        StatsMatcher matcher = TestSolverLib.matcher("((VAR :p ANY) 10) ((VAR :p LITERAL) 5)");
        Triple t = TestSolverLib.triple("(?x :p 1913)");
        double d = matcher.match(t);
        TestReorder.assertEquals((double)10.0, (double)d, (double)0.0);
    }

    @Test
    public void reorderIndexes1() {
        ReorderProcIndexes proc = new ReorderProcIndexes(new int[]{0, 1});
        BasicPattern bgp = TestSolverLib.bgp("(bgp (:x :p ?v) (:x :q ?w))");
        BasicPattern bgp2 = proc.reorder(bgp);
        TestReorder.assertEquals((Object)bgp, (Object)bgp2);
    }

    @Test
    public void reorderIndexes2() {
        ReorderProcIndexes proc = new ReorderProcIndexes(new int[]{1, 0});
        BasicPattern bgp1 = TestSolverLib.bgp("(bgp (:x :p ?v) (:x :q ?w))");
        BasicPattern bgp2 = TestSolverLib.bgp("(bgp (:x :q ?w) (:x :p ?v))");
        BasicPattern bgp3 = proc.reorder(bgp1);
        TestReorder.assertEquals((Object)bgp2, (Object)bgp3);
    }

    @Test
    public void stats_01() {
        StatsMatcher m = TestSolverLib.matcher("((:x :p ANY) 5)");
        ReorderWeighted transform = new ReorderWeighted(m);
        BasicPattern bgp = TestSolverLib.bgp("(bgp)");
        BasicPattern bgp2 = transform.reorder(bgp);
        TestReorder.assertEquals((Object)bgp2, (Object)bgp);
    }

    @Test
    public void stats_dft_01() {
        ReorderTransformation transform = ReorderLib.fixed();
        BasicPattern bgp = TestSolverLib.bgp("(bgp)");
        BasicPattern bgp2 = transform.reorder(bgp);
        TestReorder.assertEquals((Object)bgp2, (Object)bgp);
    }
}

