/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Iter;
import iterator.NullIterator;
import iterator.RepeatApplyIterator;
import iterator.Transform;
import java.util.Iterator;
import lib.Tuple;

public class StageMatchTriple
extends RepeatApplyIterator<BindingNodeId> {
    private final NodeTupleTable nodeTupleTable;
    private final Tuple<Node> tuple;
    private final ExecutionContext execCxt;

    public StageMatchTriple(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> tuple, ExecutionContext execCxt) {
        super(input);
        this.nodeTupleTable = nodeTupleTable;
        this.tuple = tuple;
        this.execCxt = execCxt;
    }

    @Override
    protected Iterator<BindingNodeId> makeNextStage(final BindingNodeId input) {
        NodeId[] ids = new NodeId[this.tuple.size()];
        final Var[] var = new Var[this.tuple.size()];
        for (int i = 0; i < this.tuple.size(); ++i) {
            Node n = this.tuple.get(i);
            NodeId nId = StageMatchTriple.idFor(this.nodeTupleTable.getNodeTable(), input, n);
            if (nId == NodeId.NodeDoesNotExist) {
                new NullIterator();
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTriple.asVar(n);
        }
        Iterator<Tuple<NodeId>> tuples = this.nodeTupleTable.getTupleTable().find(Tuple.create(ids));
        Transform<Tuple<NodeId>, BindingNodeId> binder = new Transform<Tuple<NodeId>, BindingNodeId>(){

            @Override
            public BindingNodeId convert(Tuple<NodeId> tuple) {
                BindingNodeId output = new BindingNodeId(input);
                for (int i = 0; i < var.length; ++i) {
                    Var v = var[i];
                    if (v == null) continue;
                    NodeId id = tuple.get(i);
                    if (StageMatchTriple.reject(output, v, id)) {
                        return null;
                    }
                    output.put(v, id);
                }
                return output;
            }
        };
        return Iter.iter(tuples).map(binder).removeNulls();
    }

    private static boolean reject(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return false;
        }
        return !((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar((Node)node)) {
            return Var.alloc((Node)node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar((Node)node)) {
            NodeId n = (NodeId)input.get(Var.alloc((Node)node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

