/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.tdb.lib.Lib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.solver.BindingTDB;
import com.hp.hpl.jena.tdb.solver.QueryIterTDB;
import com.hp.hpl.jena.tdb.solver.StageMatchTriple;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Iter;
import iterator.Transform;
import java.util.Iterator;
import java.util.List;
import lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverLib {
    private static Logger log = LoggerFactory.getLogger(SolverLib.class);
    public static final ConvertNodeIDToNode converter = new ConvertNodeIDToNode(){

        @Override
        public Iterator<Binding> convert(NodeTable nodeTable, Iterator<BindingNodeId> iterBindingIds) {
            return Iter.map(iterBindingIds, SolverLib.convToBinding(nodeTable));
        }
    };

    public static QueryIterator execute(GraphTDB graph, BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        List triples = pattern.getList();
        QueryIterator iter = input;
        NodeTable nodeTable = graph.getNodeTupleTable().getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map(iter, SolverLib.convFromBinding(nodeTable));
        for (Triple triple : triples) {
            Tuple<Node> t = graph.asTuple(triple);
            chain = SolverLib.solve(graph.getNodeTupleTable(), chain, t, execCxt);
        }
        Iterator<Binding> iterBinding = converter.convert(nodeTable, chain);
        return new QueryIterTDB(iterBinding, input, execCxt);
    }

    public static QueryIterator execute(DatasetGraphTDB ds, Node graphNode, BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        List triples = pattern.getList();
        NodeTupleTable nodeTuples = ds.getQuadTable().getNodeTupleTable();
        QueryIterator iter = input;
        NodeTable nodeTable = nodeTuples.getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map(iter, SolverLib.convFromBinding(nodeTable));
        for (Triple triple : triples) {
            Tuple<Node> tuple = Tuple.create(graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
            chain = SolverLib.solve(nodeTuples, chain, tuple, execCxt);
        }
        Iterator<Binding> iterBinding = converter.convert(nodeTable, chain);
        return new QueryIterTDB(iterBinding, input, execCxt);
    }

    private static Iterator<BindingNodeId> solve(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> chain, Tuple<Node> tuple, ExecutionContext execCxt) {
        return new StageMatchTriple(nodeTupleTable, chain, tuple, execCxt);
    }

    private static Transform<BindingNodeId, Binding> convToBinding(final NodeTable nodeTable) {
        return new Transform<BindingNodeId, Binding>(){

            @Override
            public Binding convert(BindingNodeId bindingNodeIds) {
                return new BindingTDB(null, bindingNodeIds, nodeTable);
            }
        };
    }

    private static Transform<Binding, BindingNodeId> convFromBinding(final NodeTable nodeTable) {
        return new Transform<Binding, BindingNodeId>(){

            @Override
            public BindingNodeId convert(Binding binding) {
                if (binding instanceof BindingTDB) {
                    return ((BindingTDB)binding).getBindingId();
                }
                BindingNodeId b = new BindingNodeId();
                Iterator vars = binding.vars();
                while (vars.hasNext()) {
                    Var v = (Var)vars.next();
                    Node n = binding.get(v);
                    NodeId id = nodeTable.getNodeIdForNode(n);
                    b.put(v, id);
                }
                return b;
            }
        };
    }

    public static String strPattern(BasicPattern pattern) {
        List triples = pattern.getList();
        String x = Iter.asString(triples, "\n  ");
        return Lib.printAbbrev(x);
    }

    public static interface ConvertNodeIDToNode {
        public Iterator<Binding> convert(NodeTable var1, Iterator<BindingNodeId> var2);
    }
}

