/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;

public class QueryEngineTDB
extends QueryEngineMain {
    Binding input;
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphTDB;
        }

        public Plan create(Query query, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(query, (DatasetGraphTDB)dataset, input, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphTDB;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(op, (DatasetGraphTDB)dataset, binding, context);
            return engine.getPlan();
        }
    };

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    private QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context) {
        super(op, (DatasetGraph)dataset, input, context);
        this.input = input;
    }

    private QueryEngineTDB(Query query, DatasetGraphTDB dataset, Binding input, Context context) {
        super(query, (DatasetGraph)dataset, input, context);
        this.input = input;
    }

    protected Op modifyOp(Op op) {
        op = Substitute.substitute((Op)op, (Binding)this.input);
        op = super.modifyOp(op);
        op = Algebra.toQuadForm((Op)op);
        return op;
    }
}

