/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinct;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPeek;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterProject;
import com.hp.hpl.jena.sparql.engine.main.OpExecutor;
import com.hp.hpl.jena.sparql.engine.main.OpExecutorFactory;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.solver.SolverLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderProc;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.util.ArrayList;
import lib.Log;
import lib.StrUtils;

public class OpExecutorTDB
extends OpExecutor {
    public static final OpExecutorFactory altFactory = new OpExecutorFactory(){

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorTDB(execCxt);
        }
    };
    private static final String executeNow = "TDB:NoReorder";
    private static Transform labelBGP = new TransformCopy(){

        public Op transform(OpBGP opBGP) {
            return OpLabel.create((Object)OpExecutorTDB.executeNow, (Op)opBGP);
        }
    };
    private final boolean isForTDB;
    private final boolean isUnionDefaultGraph;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryTDB();

    public OpExecutorTDB(ExecutionContext execCxt) {
        super(execCxt);
        this.isForTDB = execCxt.getActiveGraph() instanceof GraphTDB;
        this.isUnionDefaultGraph = execCxt.getContext().isTrue(TDB.symUnionDefaultGraph);
    }

    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        ReorderTransformation transform;
        if (!this.isForTDB) {
            return super.execute(quadPattern, input);
        }
        if (!(this.execCxt.getDataset() instanceof DatasetGraphTDB)) {
            return super.execute(quadPattern, input);
        }
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        BasicPattern bgp = quadPattern.getBasicPattern();
        Node gn = quadPattern.getGraphNode();
        boolean isDefaultGraph = false;
        if (gn.equals((Object)Quad.defaultGraphIRI)) {
            isDefaultGraph = true;
        }
        if (!this.isUnionDefaultGraph && quadPattern.isDefaultGraph()) {
            isDefaultGraph = true;
        }
        if (isDefaultGraph) {
            return OpExecutorTDB.optimizeExecute(ds.getDefaultGraph(), input, bgp, null, this.execCxt);
        }
        boolean doingUnion = false;
        if (this.isUnionDefaultGraph && quadPattern.isDefaultGraph()) {
            doingUnion = true;
        }
        if (gn.equals((Object)Quad.unionGraph)) {
            doingUnion = true;
        }
        if (doingUnion) {
            gn = VarAlloc.getVarAllocator().allocVar();
        }
        if ((transform = ds.getTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create((QueryIterator)input, (ExecutionContext)this.execCxt);
            input = peek;
            bgp = OpExecutorTDB.reorder(bgp, peek, transform);
        }
        QueryIterator qIter = SolverLib.execute(ds, gn, bgp, input, this.execCxt);
        if (doingUnion) {
            ArrayList vars = new ArrayList();
            OpVars.vars((BasicPattern)bgp, vars);
            qIter = new QueryIterProject(qIter, vars, this.execCxt);
            qIter = new QueryIterDistinct(qIter, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opBGP, input);
        }
        if (this.isUnionDefaultGraph) {
            return this.execute(new OpQuadPattern(Quad.unionGraph, opBGP.getPattern()), input);
        }
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB.optimizeExecute(graph, input, opBGP.getPattern(), null, this.execCxt);
    }

    protected QueryIterator execute(OpLabel opLabel, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opLabel, input);
        }
        if (executeNow.equals(opLabel.getObject())) {
            GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opLabel.getSubOp();
            return SolverLib.execute(graph, opBGP.getPattern(), input, this.execCxt);
        }
        return super.execute(opLabel, input);
    }

    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opFilter, input);
        }
        if (!OpBGP.isBGP((Op)opFilter.getSubOp())) {
            return super.execute(opFilter, input);
        }
        OpBGP opBGP = (OpBGP)opFilter.getSubOp();
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB.optimizeExecute(graph, input, opBGP.getPattern(), opFilter.getExprs(), this.execCxt);
    }

    public static QueryIterator optimizeExecute(GraphTDB graph, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        if (!input.hasNext()) {
            return input;
        }
        QueryIterPeek peek = QueryIterPeek.create((QueryIterator)input, (ExecutionContext)execCxt);
        input = null;
        BasicPattern pattern2 = Substitute.substitute((BasicPattern)pattern, (Binding)peek.peek());
        ReorderTransformation transform = graph.getReorderTransform();
        if (transform != null) {
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        Object op = null;
        op = exprs != null ? TransformFilterPlacement.transform((ExprList)exprs, (BasicPattern)pattern) : new OpBGP(pattern);
        if (execCxt.getContext().isTrue(TDB.symLogExec) && TDB.logExec.isInfoEnabled()) {
            String x = op.toString();
            x = StrUtils.chop(x);
            while (x.endsWith("\n")) {
                x = StrUtils.chop(x);
            }
            while (x.endsWith("\r")) {
                x = StrUtils.chop(x);
            }
            x = "Execute:: \n" + x;
            TDB.logExec.info(x);
        }
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute((Op)op, (QueryIterator)peek, (ExecutionContext)ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            BasicPattern pattern2 = Substitute.substitute((BasicPattern)pattern, (Binding)peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    private static class OpExecutorPlainTDB
    extends OpExecutor {
        public OpExecutorPlainTDB(ExecutionContext execCxt) {
            super(execCxt);
        }

        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                return SolverLib.execute((GraphTDB)g, opBGP.getPattern(), input, this.execCxt);
            }
            Log.warn((Object)this, "Non-IGraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opBGP, input);
        }
    }

    private static class OpExecutorPlainFactoryTDB
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryTDB() {
        }

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainTDB(execCxt);
        }
    }
}

