/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import java.util.Map;
import lib.Log;

public class BindingTDB
extends BindingBase {
    private final NodeTable nodeTable;
    private final BindingNodeId idBinding;
    private static final boolean caching = false;
    private final Map<Var, Node> cache = null;

    public BindingTDB(Binding parent, BindingNodeId idBinding, NodeTable nodeTable) {
        super(parent);
        this.idBinding = idBinding;
        this.nodeTable = nodeTable;
    }

    protected void add1(Var var, Node node) {
        throw new UnsupportedOperationException();
    }

    protected int size1() {
        return this.idBinding.size();
    }

    public Iterator<Var> vars1() {
        return this.idBinding.iterator();
    }

    public boolean contains1(Var var) {
        return this.idBinding.containsKey(var);
    }

    public BindingNodeId getBindingId() {
        return this.idBinding;
    }

    public NodeId getNodeId(Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        if (id != null) {
            return id;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BindingTDB) {
            return ((BindingTDB)this.parent).getNodeId(var);
        }
        return null;
    }

    public Node get1(Var var) {
        try {
            Node n = this.cacheGet(var);
            if (n != null) {
                return n;
            }
            NodeId id = (NodeId)this.idBinding.get(var);
            if (id == null) {
                return null;
            }
            n = this.nodeTable.getNodeForNodeId(id);
            this.cachePut(var, n);
            return n;
        }
        catch (Exception ex) {
            Log.fatal((Object)this, String.format("get1(%s)", var), (Throwable)ex);
            return null;
        }
    }

    private void cachePut(Var var, Node n) {
        if (this.cache != null) {
            this.cache.put(var, n);
        }
    }

    private Node cacheGet(Var var) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(var);
    }

    protected void checkAdd1(Var var, Node node) {
        throw new UnsupportedOperationException();
    }

    protected void format(StringBuffer sbuff, Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        String extra = "";
        if (id != null) {
            extra = "/" + id;
        }
        Node node = this.get(var);
        String tmp = FmtUtils.stringForObject((Object)node);
        sbuff.append("( ?" + var.getVarName() + extra + " = " + tmp + " )");
    }
}

