/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.pgraph.TripleIndex;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Filter;
import iterator.Iter;
import iterator.NullIterator;
import iterator.SingletonIterator;
import java.util.Iterator;
import lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleTable1
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(TripleTable1.class);
    private TripleIndex indexSPO = null;
    private TripleIndex indexPOS = null;
    private TripleIndex indexOSP = null;
    private NodeTable nodeTable = null;
    private Location location;

    protected TripleTable1() {
    }

    public TripleTable1(TripleIndex spo, TripleIndex pos, TripleIndex osp, NodeTable nodeTable, Location location) {
        if (spo == null) {
            throw new TDBException("SPO index is required");
        }
        this.indexSPO = spo;
        this.indexPOS = pos;
        this.indexOSP = osp;
        this.nodeTable = nodeTable;
        this.location = location;
    }

    public boolean add(Triple t) {
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        NodeId sId = this.storeNode(s);
        NodeId pId = this.storeNode(p);
        NodeId oId = this.storeNode(o);
        if (this.indexSPO != null && !this.indexSPO.add(sId, pId, oId)) {
            this.duplicate(t, sId, pId, oId);
            return false;
        }
        if (this.indexPOS != null && !this.indexPOS.add(sId, pId, oId)) {
            throw new TDBException("POS duplicate: " + t);
        }
        if (this.indexOSP != null && !this.indexOSP.add(sId, pId, oId)) {
            throw new TDBException("OSP duplicate: " + t);
        }
        return true;
    }

    private void duplicate(Triple t, NodeId id, NodeId id2, NodeId id3) {
    }

    public boolean delete(Triple t) {
        NodeId oId;
        NodeId pId;
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        NodeId sId = this.storeNode(s);
        if (!this.indexSPO.delete(sId, pId = this.storeNode(p), oId = this.storeNode(o))) {
            return false;
        }
        if (this.indexPOS != null && !this.indexPOS.delete(sId, pId, oId)) {
            throw new TDBException("No POS entry");
        }
        if (this.indexOSP != null && !this.indexOSP.delete(sId, pId, oId)) {
            throw new TDBException("No OSP entry");
        }
        return true;
    }

    protected String encode(Node node) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        return FmtUtils.stringForNode((Node)node);
    }

    protected Node decode(String s) {
        if (s.startsWith("_:")) {
            s = s.substring(2);
            return Node.createAnon((AnonId)new AnonId(s));
        }
        return SSE.parseNode((String)s);
    }

    private final NodeId idForNode(Node node) {
        if (node == null || node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        return this.nodeTable.getNodeIdForNode(node);
    }

    protected final NodeId storeNode(Node node) {
        return this.nodeTable.storeNode(node);
    }

    protected final Node retrieveNode(NodeId id) {
        return this.nodeTable.getNodeForNodeId(id);
    }

    public Iterator<Triple> find(Node s, Node p, Node o) {
        boolean o_set;
        NodeId subj = this.idForNode(s);
        if (subj == NodeId.NodeDoesNotExist) {
            return new NullIterator<Triple>();
        }
        NodeId pred = this.idForNode(p);
        if (pred == NodeId.NodeDoesNotExist) {
            return new NullIterator<Triple>();
        }
        NodeId obj = this.idForNode(o);
        if (obj == NodeId.NodeDoesNotExist) {
            return new NullIterator<Triple>();
        }
        boolean s_set = subj != NodeId.NodeIdAny;
        boolean p_set = pred != NodeId.NodeIdAny;
        boolean bl = o_set = obj != NodeId.NodeIdAny;
        if (s_set && p_set && o_set) {
            if (this.indexSPO.find(subj, pred, obj).hasNext()) {
                return new SingletonIterator<Triple>(new Triple(s, p, o));
            }
            return new NullIterator<Triple>();
        }
        Iterator<Tuple<NodeId>> _iter = this.find(subj, pred, obj);
        Iterator<Triple> iter = TupleLib.convertToTriples(this.nodeTable, _iter);
        return iter;
    }

    public Iterator<Tuple<NodeId>> find(NodeId subj, NodeId pred, NodeId obj) {
        int w;
        if (subj == NodeId.NodeIdAny) {
            subj = null;
        }
        if (pred == NodeId.NodeIdAny) {
            pred = null;
        }
        if (obj == NodeId.NodeIdAny) {
            obj = null;
        }
        int numSlots = 0;
        if (subj != null) {
            ++numSlots;
        }
        if (pred != null) {
            ++numSlots;
        }
        if (obj != null) {
            ++numSlots;
        }
        TripleIndex index = null;
        int indexNumSlots = 0;
        if (this.indexSPO != null && (w = this.indexSPO.weight(subj, pred, obj)) > indexNumSlots) {
            indexNumSlots = w;
            index = this.indexSPO;
        }
        if (this.indexPOS != null && (w = this.indexPOS.weight(subj, pred, obj)) > indexNumSlots) {
            indexNumSlots = w;
            index = this.indexPOS;
        }
        if (this.indexOSP != null && (w = this.indexOSP.weight(subj, pred, obj)) > indexNumSlots) {
            indexNumSlots = w;
            index = this.indexOSP;
        }
        Iterator<Tuple<NodeId>> iter = null;
        iter = index == null ? this.indexSPO.all() : index.find(subj, pred, obj);
        if (indexNumSlots < numSlots) {
            iter = this.scan(iter, subj, pred, obj);
        }
        return iter;
    }

    private Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, final NodeId subj, final NodeId pred, final NodeId obj) {
        Filter<Tuple<NodeId>> filter = new Filter<Tuple<NodeId>>(){

            @Override
            public boolean accept(Tuple<NodeId> item) {
                if (subj != null && !item.get(0).equals(subj)) {
                    return false;
                }
                if (pred != null && !item.get(1).equals(pred)) {
                    return false;
                }
                return obj == null || item.get(2).equals(obj);
            }
        };
        return Iter.filter(iter, filter);
    }

    public final void close() {
        if (this.indexSPO != null) {
            this.indexSPO.close();
        }
        if (this.indexPOS != null) {
            this.indexPOS.close();
        }
        if (this.indexOSP != null) {
            this.indexOSP.close();
        }
        if (this.nodeTable != null) {
            this.nodeTable.close();
        }
    }

    public void dumpIndexes() {
        if (this.indexSPO == null && this.indexPOS == null && this.indexOSP == null) {
            System.out.println("No indexes");
            return;
        }
        if (this.indexSPO != null) {
            this.indexSPO.dump();
        }
        if (this.indexPOS != null) {
            this.indexPOS.dump();
        }
        if (this.indexOSP != null) {
            this.indexOSP.dump();
        }
    }

    @Override
    public void sync(boolean force) {
        if (this.indexSPO != null) {
            this.indexSPO.sync(force);
        }
        if (this.indexPOS != null) {
            this.indexPOS.sync(force);
        }
        if (this.indexOSP != null) {
            this.indexOSP.sync(force);
        }
        if (this.nodeTable != null) {
            this.nodeTable.sync(force);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public TripleIndex getIndexSPO() {
        return this.indexSPO;
    }

    public TripleIndex getIndexPOS() {
        return this.indexPOS;
    }

    public TripleIndex getIndexOSP() {
        return this.indexOSP;
    }

    public void setIndexSPO(TripleIndex indexSPO) {
        this.indexSPO = indexSPO;
    }

    public void setIndexPOS(TripleIndex indexPOS) {
        this.indexPOS = indexPOS;
    }

    public void setIndexOSP(TripleIndex indexOSP) {
        this.indexOSP = indexOSP;
    }

    public NodeTable getNodeTable() {
        return this.nodeTable;
    }

    public void setNodeTable(NodeTable nodeTable) {
        this.nodeTable = nodeTable;
    }
}

