/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.IndexLib;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.pgraph.Descriptor;
import com.hp.hpl.jena.tdb.pgraph.Misc;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Iter;
import iterator.Transform;
import java.util.Iterator;
import lib.Bytes;
import lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleIndex {
    private static Logger log = LoggerFactory.getLogger(TripleIndex.class);
    protected Descriptor desc;
    protected RangeIndex index;
    private Transform<Record, Tuple<NodeId>> transformToSPO = new Transform<Record, Tuple<NodeId>>(){

        @Override
        public Tuple<NodeId> convert(Record item) {
            return TripleIndex.this.desc.tuple(item);
        }
    };

    public TripleIndex(String description, RangeIndex index) {
        this.desc = new Descriptor(description, index.getRecordFactory());
        this.index = index;
    }

    public boolean add(NodeId s, NodeId p, NodeId o) {
        Record r = this.desc.record(s, p, o);
        return this.index.add(r);
    }

    public boolean delete(NodeId s, NodeId p, NodeId o) {
        Record r = this.desc.record(s, p, o);
        return this.index.delete(r);
    }

    private final Iterator<Tuple<NodeId>> asTuples(Iterator<Record> iter) {
        return Iter.map(iter, this.transformToSPO);
    }

    public RangeIndex getIndex() {
        return this.index;
    }

    public String getDescription() {
        return this.desc.getDescription();
    }

    public Iterator<Tuple<NodeId>> all() {
        Iterator<Record> iter = this.index.iterator();
        return this.asTuples(iter);
    }

    public int weight(NodeId s, NodeId p, NodeId o) {
        int numSlots = 0;
        NodeId X = this.desc.getSlot1(s, p, o);
        if (X == null) {
            return numSlots;
        }
        ++numSlots;
        NodeId Y = this.desc.getSlot2(s, p, o);
        if (Y == null) {
            return numSlots;
        }
        ++numSlots;
        NodeId Z = this.desc.getSlot3(s, p, o);
        if (Z == null) {
            return numSlots;
        }
        return ++numSlots;
    }

    public Iterator<Tuple<NodeId>> find(NodeId s, NodeId p, NodeId o) {
        long max3;
        long min3;
        long max2;
        long min2;
        long min1;
        NodeId X = this.desc.getSlot1(s, p, o);
        NodeId Y = this.desc.getSlot2(s, p, o);
        NodeId Z = this.desc.getSlot3(s, p, o);
        if (X == null) {
            throw new TDBException("No first key");
        }
        long max1 = min1 = X.getId();
        if (Y == null) {
            min2 = 0L;
            max2 = 0L;
            min3 = 0L;
            max3 = 0L;
        } else {
            max2 = min2 = Y.getId();
            if (Z == null) {
                min3 = 0L;
                max3 = 0L;
            } else {
                min3 = Z.getId();
                max3 = min3 + 1L;
            }
        }
        Record r1 = Misc.record(this.index.getRecordFactory(), min1, min2, min3);
        Record r2 = Misc.record(this.index.getRecordFactory(), ++max1, ++max2, max3);
        Iterator<Record> iter = this.index.iterator(r1, r2);
        return this.asTuples(iter);
    }

    public Iterator<Tuple<NodeId>> tuplesNativeOrder() {
        Transform<Record, Tuple<NodeId>> transform0 = new Transform<Record, Tuple<NodeId>>(){

            @Override
            public Tuple<NodeId> convert(Record e) {
                long x = this.getId(e, 0);
                long y = this.getId(e, 8);
                long z = this.getId(e, 16);
                return Tuple.create(NodeId.create(x), NodeId.create(y), NodeId.create(z));
            }

            private final long getId(Record r, int idx) {
                return Bytes.getLong(r.getKey(), idx);
            }
        };
        return Iter.map(this.index.iterator(), transform0);
    }

    public boolean sameAs(TripleIndex other) {
        Tuple<NodeId> tuple2;
        Tuple<NodeId> tuple1;
        Iterator<Tuple<NodeId>> iter1 = this.tuplesNativeOrder();
        Iterator<Tuple<NodeId>> iter2 = other.tuplesNativeOrder();
        do {
            if (!iter1.hasNext()) {
                return !iter2.hasNext();
            }
            if (iter2.hasNext()) continue;
            return false;
        } while ((tuple1 = iter1.next()).equals(tuple2 = iter2.next()));
        return false;
    }

    public void copyInto(TripleIndex index2) {
        Iterator<Tuple<NodeId>> iter = this.all();
        int i = 0;
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            index2.add(tuple.get(0), tuple.get(1), tuple.get(2));
            ++i;
        }
    }

    public String toString() {
        return "TripleIndex: " + this.desc.getDescription();
    }

    public void sync(boolean force) {
        this.index.sync(force);
    }

    public void close() {
        this.index.close();
    }

    public void dump() {
        System.out.println("Index: " + this.desc.getDescription());
        IndexLib.print(this.getIndex());
    }
}

