/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTableIndex;
import com.hp.hpl.jena.tdb.pgraph.PGraph;
import com.hp.hpl.jena.tdb.pgraph.TripleIndex;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderLib;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGraphFactory {
    public static final String indexSPO = "SPO";
    public static final String indexPOS = "POS";
    public static final String indexOSP = "OSP";
    private static Logger log = LoggerFactory.getLogger(PGraphFactory.class);
    private static Logger logExec = LoggerFactory.getLogger(PGraphFactory.class);
    private static Logger logInfo = LoggerFactory.getLogger(PGraphFactory.class);

    public static PGraph create(Location location) {
        if (location == null) {
            throw new TDBException("Location is null");
        }
        if (location.exists("node2id", "exh")) {
            log.info("Existing extendible hash index for nodes found - using ExtHash/B+Tree indexing");
            return PGraphFactory.create(IndexBuilder.getExtHash(), location);
        }
        if (location.exists(indexSPO, "idx")) {
            log.info("Existing BTree index found - using BTree indexing");
            return PGraphFactory.create(IndexBuilder.getBTree(), location);
        }
        if (location.exists(indexSPO, "idn")) {
            log.debug("Existing B+Tree index found - using B+Tree indexing");
            return PGraphFactory.create(IndexBuilder.getBPlusTree(), location);
        }
        return PGraphFactory.create(IndexBuilder.get(), location);
    }

    public static PGraph create(IndexBuilder indexBuilder, Location location) {
        if (location == null) {
            log.warn("Null location");
        }
        RangeIndex idxSPO = indexBuilder.newRangeIndex(location, PGraph.indexRecordFactory, indexSPO);
        TripleIndex triplesSPO = new TripleIndex(indexSPO, idxSPO);
        RangeIndex idxPOS = indexBuilder.newRangeIndex(location, PGraph.indexRecordFactory, indexPOS);
        TripleIndex triplesPOS = new TripleIndex(indexPOS, idxPOS);
        RangeIndex idxOSP = indexBuilder.newRangeIndex(location, PGraph.indexRecordFactory, indexOSP);
        TripleIndex triplesOSP = new TripleIndex(indexOSP, idxOSP);
        NodeTableIndex nodeTable = new NodeTableIndex(indexBuilder, location, "nodes.dat", "node2id", SystemTDB.Node2NodeIdCacheSize, SystemTDB.NodeId2NodeCacheSize);
        ReorderTransformation reorder = PGraphFactory.chooseOptimizer(location);
        return new PGraph(triplesSPO, triplesPOS, triplesOSP, nodeTable, reorder, location);
    }

    private static ReorderTransformation chooseOptimizer(Location location) {
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted(location.getPath("stats.opt"));
                logInfo.info("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            logInfo.info("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            logInfo.info("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultOptimizer;
        }
        if (reorder == null) {
            logExec.warn("No BGP optimizer");
        }
        return reorder;
    }

    public static PGraph createMem() {
        return PGraphFactory.createMem(IndexBuilder.mem());
    }

    public static PGraph createMem(IndexBuilder factory) {
        RangeIndex idxSPO = factory.newRangeIndex(null, PGraph.indexRecordFactory, indexSPO);
        TripleIndex triplesSPO = new TripleIndex(indexSPO, idxSPO);
        RangeIndex idxPOS = factory.newRangeIndex(null, PGraph.indexRecordFactory, indexPOS);
        TripleIndex triplesPOS = new TripleIndex(indexPOS, idxPOS);
        RangeIndex idxOSP = factory.newRangeIndex(null, PGraph.indexRecordFactory, indexOSP);
        TripleIndex triplesOSP = new TripleIndex(indexOSP, idxOSP);
        NodeTableIndex nodeTable = new NodeTableIndex(factory);
        return new PGraph(triplesSPO, triplesPOS, triplesOSP, nodeTable, null, null);
    }
}

