/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.graph.GraphSyncListener;
import com.hp.hpl.jena.tdb.graph.QueryHandlerTDB;
import com.hp.hpl.jena.tdb.graph.UpdateListener;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.pgraph.TripleIndex;
import com.hp.hpl.jena.tdb.pgraph.TripleTable1;
import com.hp.hpl.jena.tdb.solver.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.solver.reorder.Reorderable;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGraph
extends GraphBase
implements Sync,
Reorderable {
    private static Logger log = LoggerFactory.getLogger(PGraph.class);
    static final RecordFactory indexRecordFactory = new RecordFactory(24, 0);
    static final RecordFactory nodeRecordFactory = new RecordFactory(8, 8);
    private final QueryHandlerTDB queryHandler = null;
    private ReorderTransformation reorderTransform = null;
    private TripleTable1 tripleTable;

    protected PGraph() {
    }

    public PGraph(TripleIndex spo, TripleIndex pos, TripleIndex osp, NodeTable nodeTable, ReorderTransformation reorderTransform, Location location) {
        if (spo == null) {
            throw new TDBException("SPO index is required");
        }
        this.tripleTable = new TripleTable1(spo, pos, osp, nodeTable, location);
        this.reorderTransform = reorderTransform;
        int syncPoint = SystemTDB.SyncTick;
        if (syncPoint > 0) {
            this.getEventManager().register((GraphListener)new GraphSyncListener(this, syncPoint));
        }
        this.getEventManager().register((GraphListener)new UpdateListener(this));
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public void performAdd(Triple t) {
        boolean changed = this.tripleTable.add(t);
        if (!changed) {
            this.duplicate(t);
        }
    }

    private void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && log.isInfoEnabled()) {
            String $ = FmtUtils.stringForTriple((Triple)t, (PrefixMapping)this.getPrefixMapping());
            log.info("Duplicate: (" + $ + ")");
        }
    }

    public void performDelete(Triple t) {
        boolean changed = this.tripleTable.delete(t);
    }

    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        Iterator<Triple> iter = this.tripleTable.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iter == null) {
            return new NullIterator();
        }
        return new MapperIterator(iter);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                public boolean sizeAccurate() {
                    return true;
                }

                public boolean addAllowed() {
                    return true;
                }

                public boolean addAllowed(boolean every) {
                    return true;
                }

                public boolean deleteAllowed() {
                    return true;
                }

                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                public boolean canBeEmpty() {
                    return true;
                }

                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                public boolean findContractSafe() {
                    return false;
                }

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    public final void close() {
        this.tripleTable.close();
        super.close();
    }

    @Override
    public void sync(boolean force) {
        this.tripleTable.sync(force);
    }

    @Override
    public ReorderTransformation getReorderTransform() {
        return this.reorderTransform;
    }

    public TripleTable1 getTripleTable() {
        return this.tripleTable;
    }

    public Location getLocation() {
        return this.tripleTable.getLocation();
    }

    static class MapperIterator
    extends NiceIterator {
        Iterator<Triple> iter;

        MapperIterator(Iterator<Triple> iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Triple next() {
            return this.iter.next();
        }
    }
}

