/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.pgraph.Misc;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.HashSet;
import lib.Tuple;

public class Descriptor {
    private static final Selector sel_s = Selector.sel_1;
    private static final Selector sel_p = Selector.sel_2;
    private static final Selector sel_o = Selector.sel_3;
    private final Selector sel_slot_1;
    private final Selector sel_slot_2;
    private final Selector sel_slot_3;
    private final Selector sel_extract_s;
    private final Selector sel_extract_p;
    private final Selector sel_extract_o;
    private final RecordFactory recordFactory;
    private final String description;

    public Descriptor(String desc, RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
        this.checkDescriptor(desc);
        this.description = desc;
        this.sel_slot_1 = this.getSelector(desc, 0);
        this.sel_slot_2 = this.getSelector(desc, 1);
        this.sel_slot_3 = this.getSelector(desc, 2);
        this.sel_extract_s = this.findSelector(desc, 'S');
        this.sel_extract_p = this.findSelector(desc, 'P');
        this.sel_extract_o = this.findSelector(desc, 'O');
    }

    private void checkDescriptor(String desc) {
        if (desc.length() != 3) {
            throw new TDBException("Bad descriptor: " + desc);
        }
        HashSet<Character> x = new HashSet<Character>();
        for (int i = 0; i < desc.length(); ++i) {
            char ch = desc.charAt(i);
            x.add(Character.valueOf(ch));
        }
        if (x.size() != desc.length()) {
            throw new TDBException("Bad descriptor: " + desc);
        }
    }

    private Selector getSelector(String desc, int i) {
        char ch = desc.charAt(i);
        ch = Character.toUpperCase(ch);
        switch (ch) {
            case 'S': {
                return sel_s;
            }
            case 'P': {
                return sel_p;
            }
            case 'O': {
                return sel_o;
            }
        }
        throw new TDBException("Can't find a select for " + ch);
    }

    private Selector findSelector(String desc, char ch) {
        int idx = desc.indexOf(ch);
        if (idx < 0) {
            throw new TDBException("Bad findSelector: " + desc + " : " + ch);
        }
        return Selector.selectors[idx];
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "Descriptor: " + this.description;
    }

    public final NodeId getSubj(NodeId x, NodeId y, NodeId z) {
        return this.sel_extract_s.choose(x, y, z);
    }

    public final NodeId getPred(NodeId x, NodeId y, NodeId z) {
        return this.sel_extract_p.choose(x, y, z);
    }

    public final NodeId getObj(NodeId x, NodeId y, NodeId z) {
        return this.sel_extract_o.choose(x, y, z);
    }

    public final NodeId getSlot1(NodeId x, NodeId y, NodeId z) {
        return this.sel_slot_1.choose(x, y, z);
    }

    public final NodeId getSlot2(NodeId x, NodeId y, NodeId z) {
        return this.sel_slot_2.choose(x, y, z);
    }

    public final NodeId getSlot3(NodeId x, NodeId y, NodeId z) {
        return this.sel_slot_3.choose(x, y, z);
    }

    public final NodeId getSlot(int i, NodeId x, NodeId y, NodeId z) {
        if (i == 0) {
            return this.getSlot1(x, y, z);
        }
        if (i == 1) {
            return this.getSlot2(x, y, z);
        }
        if (i == 2) {
            return this.getSlot3(x, y, z);
        }
        throw new TDBException("Descriotion.get(i,x,y,z): index out of range: " + i);
    }

    public final Record record(Tuple<NodeId> tuple) {
        return this.record(tuple.get(0), tuple.get(1), tuple.get(2));
    }

    public final Record record(NodeId s, NodeId p, NodeId o) {
        NodeId id1 = this.sel_slot_1.choose(s, p, o);
        NodeId id2 = this.sel_slot_2.choose(s, p, o);
        NodeId id3 = this.sel_slot_3.choose(s, p, o);
        Record r = Misc.record(this.recordFactory, id1, id2, id3);
        return r;
    }

    public final Tuple<NodeId> tuple(Record e) {
        NodeId x = NodeLib.getNodeId(e, 0);
        NodeId y = NodeLib.getNodeId(e, 8);
        NodeId z = NodeLib.getNodeId(e, 16);
        NodeId sId = this.getSubj(x, y, z);
        NodeId pId = this.getPred(x, y, z);
        NodeId oId = this.getObj(x, y, z);
        return Tuple.create(sId, pId, oId);
    }

    public RecordFactory getFactory() {
        return this.recordFactory;
    }

    static interface Selector {
        public static final Selector sel_1 = new Selector(){

            @Override
            public NodeId choose(NodeId n1, NodeId n2, NodeId n3) {
                return n1;
            }
        };
        public static final Selector sel_2 = new Selector(){

            @Override
            public NodeId choose(NodeId n1, NodeId n2, NodeId n3) {
                return n2;
            }
        };
        public static final Selector sel_3 = new Selector(){

            @Override
            public NodeId choose(NodeId n1, NodeId n2, NodeId n3) {
                return n3;
            }
        };
        public static final Selector[] selectors = new Selector[]{sel_1, sel_2, sel_3};

        public NodeId choose(NodeId var1, NodeId var2, NodeId var3);
    }

    static interface Selector2 {
        public static final Selector2 sel_1 = new Selector2(){

            @Override
            public NodeId choose(Tuple<NodeId> tuple) {
                return tuple.get(1);
            }
        };

        public NodeId choose(Tuple<NodeId> var1);
    }
}

