/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.pgraph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.util.graph.GraphListenerBase;
import com.hp.hpl.jena.sparql.util.graph.GraphLoadMonitor;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.pgraph.PGraph;
import com.hp.hpl.jena.tdb.pgraph.TripleIndex;
import com.hp.hpl.jena.tdb.pgraph.TripleTable1;
import com.hp.hpl.jena.tdb.solver.stats.StatsCollector;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import lib.MapUtils;
import lib.Tuple;

public class BulkLoader1 {
    private PGraph graph;
    private TripleTable1 tripleTable;
    private Symbol symTesting = SystemTDB.allocSymbol("testing");
    private boolean testingSpecial = false;
    private boolean showProgress;
    private boolean doInParallel = false;
    private boolean doIncremental = false;
    private boolean doInterleaved = false;
    private boolean generateStats = false;
    private TripleIndex triplesSPO;
    private TripleIndex triplesPOS;
    private TripleIndex triplesOSP;
    private Item statsItem = null;
    GraphStatsCollector statsMonitor = new GraphStatsCollector();
    private static Object lock = new Object();

    public BulkLoader1(PGraph graph, boolean showProgress) {
        this(graph, showProgress, false, false, false);
    }

    public BulkLoader1(PGraph graph, boolean showProgress, boolean doInParallel, boolean doIncremental, boolean generateStats) {
        this.graph = graph;
        this.tripleTable = graph.getTripleTable();
        this.showProgress = showProgress;
        this.doInParallel = doInParallel;
        this.doIncremental = doIncremental;
        this.generateStats = generateStats;
        this.testingSpecial = TDB.getContext().isTrue(this.symTesting);
    }

    public void load(List<String> urls) {
        boolean rebuildIndexes;
        Model model = ModelFactory.createModelForGraph((Graph)this.graph);
        boolean bl = rebuildIndexes = !this.doIncremental;
        if (!this.graph.isEmpty()) {
            rebuildIndexes = false;
        }
        if (rebuildIndexes) {
            BulkLoader1.println("** Load empty graph");
            this.dropSecondaryIndexes();
            if (this.testingSpecial) {
                BulkLoader1.println("** Load node table only");
                this.tripleTable.setIndexSPO(null);
            }
        } else {
            BulkLoader1.println("** Load graph with existing data");
            this.generateStats = false;
        }
        Timer timer = new Timer();
        timer.startTimer();
        long count = 0L;
        for (String url : urls) {
            this.statsStart(model);
            BulkLoader1.now("-- Start data phase");
            count += this.loadOne(model, url);
            BulkLoader1.now("-- Finish data phase");
            this.statsFinish(model);
        }
        if (this.generateStats && this.statsItem != null) {
            String fn = this.tripleTable.getLocation().getPath("stats.opt");
            try {
                FileOutputStream fout = new FileOutputStream(fn);
                IndentedWriter out = new IndentedWriter((OutputStream)fout);
                ItemWriter.write((IndentedWriter)out, (Item)this.statsItem, null);
                out.ensureStartOfLine();
                out.flush();
                fout.close();
            }
            catch (IOException ex) {
                ALog.fatal((Object)this, (String)("Failed to write stats file: " + ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
        this.graph.sync(true);
        if (this.testingSpecial) {
            this.graph.close();
            return;
        }
        if (rebuildIndexes) {
            BulkLoader1.now("-- Start index phase");
            if (this.showProgress) {
                BulkLoader1.println("** Secondary indexes");
            }
            this.createSecondaryIndexes(this.showProgress);
            BulkLoader1.now("-- Finish index phase");
        }
        if (this.showProgress) {
            BulkLoader1.println("** Close graph");
        }
        this.graph.close();
        timer.endTimer();
        long time = timer.getTimeInterval();
        if (this.showProgress) {
            long tps = 1000L * count / time;
            BulkLoader1.println();
            BulkLoader1.printf("Time for load: %.2fs [%,d triples/s]\n", (double)time / 1000.0, tps);
        }
    }

    private void statsStart(Model model) {
        if (this.generateStats) {
            model.getGraph().getEventManager().register((GraphListener)this.statsMonitor);
        }
    }

    private void statsFinish(Model model) {
        if (this.generateStats) {
            model.getGraph().getEventManager().unregister((GraphListener)this.statsMonitor);
            this.statsItem = StatsCollector.format(this.statsMonitor.predicates, this.statsMonitor.count);
        }
    }

    private long loadOne(Model model, String s) {
        GraphLoadMonitor monitor = new GraphLoadMonitor(50000, false);
        if (this.showProgress) {
            model.getGraph().getEventManager().register((GraphListener)monitor);
        }
        if (!s.equals("-")) {
            FileManager.get().readModel(model, s);
        } else {
            model.read(System.in, null, "N-TRIPLES");
        }
        if (this.showProgress) {
            model.getGraph().getEventManager().unregister((GraphListener)monitor);
        }
        return this.showProgress ? monitor.getAddCount() : -1L;
    }

    private void dropSecondaryIndexes() {
        this.triplesSPO = this.tripleTable.getIndexSPO();
        this.triplesPOS = this.tripleTable.getIndexPOS();
        this.triplesOSP = this.tripleTable.getIndexOSP();
        if (this.tripleTable.getIndexPOS() != null) {
            this.tripleTable.setIndexPOS(null);
        }
        if (this.tripleTable.getIndexOSP() != null) {
            this.tripleTable.setIndexOSP(null);
        }
    }

    private void createSecondaryIndexes(boolean printTiming) {
        if (this.triplesPOS == null && this.triplesOSP == null) {
            return;
        }
        if (this.doInParallel) {
            this.createSecondaryIndexesParallel(printTiming);
        } else if (this.doInterleaved) {
            this.createSecondaryIndexesInterleaved(printTiming);
        } else {
            this.createSecondaryIndexesSequential(printTiming);
        }
    }

    private void createSecondaryIndexesParallel(boolean printTiming) {
        if (this.triplesPOS == null && this.triplesOSP == null) {
            return;
        }
        BulkLoader1.println("** Parallel index building");
        Timer timer = new Timer();
        timer.startTimer();
        int semaCount = 0;
        Semaphore sema = new Semaphore(0);
        if (this.triplesPOS != null) {
            Runnable builder1 = this.setup(sema, this.triplesSPO, this.triplesPOS, "POS", printTiming);
            new Thread(builder1).start();
            ++semaCount;
        }
        if (this.triplesOSP != null) {
            Runnable builder2 = this.setup(sema, this.triplesSPO, this.triplesOSP, "OSP", printTiming);
            new Thread(builder2).start();
            ++semaCount;
        }
        try {
            sema.acquire(semaCount);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        long time = timer.readTimer();
        if (printTiming) {
            BulkLoader1.printf("Time for POS/OSP indexing: %.2fs\n", (double)time / 1000.0);
        }
        timer.endTimer();
        this.tripleTable.setIndexOSP(this.triplesOSP);
        this.tripleTable.setIndexPOS(this.triplesPOS);
    }

    private Runnable setup(final Semaphore sema, final TripleIndex srcIndex, final TripleIndex destIndex, final String label, final boolean printTiming) {
        Runnable builder = new Runnable(){

            @Override
            public void run() {
                BulkLoader1.copyIndex(srcIndex.all(), new TripleIndex[]{destIndex}, label, printTiming);
                sema.release();
            }
        };
        return builder;
    }

    private void createSecondaryIndexesSequential(boolean printTiming) {
        long time2;
        if (this.triplesPOS == null && this.triplesOSP == null) {
            return;
        }
        Timer timer = new Timer();
        timer.startTimer();
        long time1 = timer.readTimer();
        if (this.triplesPOS != null) {
            BulkLoader1.copyIndex(this.triplesSPO.all(), new TripleIndex[]{this.triplesPOS}, "POS", printTiming);
            time2 = timer.readTimer();
            if (printTiming) {
                BulkLoader1.printf("Time for POS indexing: %.2fs\n", (double)(time2 - time1) / 1000.0);
            }
        }
        time2 = timer.readTimer();
        if (this.triplesOSP != null) {
            BulkLoader1.copyIndex(this.triplesSPO.all(), new TripleIndex[]{this.triplesOSP}, "OSP", printTiming);
            long time3 = timer.readTimer();
            if (printTiming && this.triplesOSP != null) {
                BulkLoader1.printf("Time for OSP indexing: %.2fs\n", (double)(time3 - time2) / 1000.0);
            }
            timer.endTimer();
        }
        this.tripleTable.setIndexOSP(this.triplesOSP);
        this.tripleTable.setIndexPOS(this.triplesPOS);
    }

    private void createSecondaryIndexesInterleaved(boolean printTiming) {
        if (this.triplesPOS == null && this.triplesOSP == null) {
            return;
        }
        Timer timer = new Timer();
        timer.startTimer();
        long time1 = timer.readTimer();
        BulkLoader1.copyIndex(this.triplesSPO.all(), new TripleIndex[]{this.triplesPOS, this.triplesOSP}, "POS/OSP", printTiming);
        long time2 = timer.readTimer();
        if (printTiming) {
            BulkLoader1.printf("Time for both POS and OSP indexes: %.2fs\n", (double)(time2 - time1) / 1000.0);
        }
        this.tripleTable.setIndexOSP(this.triplesOSP);
        this.tripleTable.setIndexPOS(this.triplesPOS);
    }

    private static void copyIndex(Iterator<Tuple<NodeId>> srcIter, TripleIndex[] destIndexes, String label, boolean printTiming) {
        long quantum = 100000L;
        long quantum2 = 5L * quantum;
        Timer timer = new Timer();
        long cumulative = 0L;
        long c = 0L;
        long last = 0L;
        timer.startTimer();
        int counter = 0;
        while (srcIter.hasNext()) {
            Tuple<NodeId> tuple = srcIter.next();
            for (TripleIndex destIdx : destIndexes) {
                if (destIdx == null) continue;
                destIdx.add(tuple.get(0), tuple.get(1), tuple.get(2));
            }
            ++c;
            if (printTiming && BulkLoader1.tickPoint(++cumulative, quantum)) {
                long t = timer.readTimer();
                long batchTime = t - last;
                long elapsed = t;
                last = t;
                BulkLoader1.printf("Index %s: %,d slots (Batch: %,d slots/s / Run: %,d slots/s)\n", label, cumulative, 1000L * c / batchTime, 1000L * cumulative / elapsed);
                if (BulkLoader1.tickPoint(cumulative, quantum2)) {
                    String timestamp = Utils.nowAsString();
                    String x = StringUtils.str((float)((float)elapsed / 1000.0f));
                    BulkLoader1.printf("  Elapsed: %s seconds [%s]\n", x, timestamp);
                }
                c = 0L;
            }
            ++counter;
        }
        for (TripleIndex destIdx : destIndexes) {
            if (destIdx == null) continue;
            destIdx.sync(true);
        }
        long totalTime = timer.endTimer();
        if (printTiming) {
            if (cumulative > 0L) {
                if (totalTime > 0L) {
                    BulkLoader1.printf("Index %s: %,d triples indexed in %,.2fs [%,d slots/s]\n", label, cumulative, (double)totalTime / 1000.0, 1000L * cumulative / totalTime);
                } else {
                    BulkLoader1.printf("Index %s: %,d triples indexed in %,.2fs\n", label, cumulative, (double)totalTime / 1000.0);
                }
            } else {
                BulkLoader1.printf("Index %s: 0 triples indexed\n", label);
            }
        }
    }

    private static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }

    private static synchronized void printf(String fmt, Object ... args) {
        System.out.printf(fmt, args);
    }

    private static synchronized void println() {
        System.out.println();
    }

    private static synchronized void println(String str) {
        System.out.println(str);
    }

    private static synchronized void now(String str) {
        if (str != null) {
            System.out.print(str);
            System.out.print(" : ");
        }
        System.out.println(StringUtils.str((Date)new Date()));
    }

    static class GraphStatsCollector
    extends GraphListenerBase {
        Map<Node, Integer> predicates = new HashMap<Node, Integer>();
        long count = 0L;

        GraphStatsCollector() {
        }

        protected void addEvent(Triple t) {
            MapUtils.increment(this.predicates, t.getPredicate());
            ++this.count;
        }

        protected void deleteEvent(Triple t) {
        }
    }
}

