/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.NullIterator;
import java.util.Iterator;
import lib.Tuple;

public class NodeTupleTable
implements Sync,
Closeable {
    protected final NodeTable nodeTable;
    protected final TupleTable tupleTable;

    public NodeTupleTable(int N, TupleIndex[] indexes, NodeTable nodeTable) {
        if (indexes.length == 0 || indexes[0] == null) {
            throw new TDBException("A primary index is required");
        }
        for (TupleIndex index : indexes) {
            if (N == index.getTupleLength()) continue;
            throw new TDBException(String.format("Inconsistent: TupleTable width is %d but index %s is %d", N, index.getLabel(), index.getTupleLength()));
        }
        this.tupleTable = new TupleTable(N, indexes);
        this.nodeTable = nodeTable;
    }

    public boolean addRow(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            n[i] = this.storeNode(nodes[i]);
        }
        Tuple<NodeId> t = Tuple.create(n);
        return this.tupleTable.add(t);
    }

    public boolean deleteRow(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            NodeId id = this.idForNode(nodes[i]);
            if (id == NodeId.NodeDoesNotExist) {
                return false;
            }
            n[i] = id;
        }
        Tuple<NodeId> t = Tuple.create(n);
        return this.tupleTable.delete(t);
    }

    public Iterator<Tuple<Node>> find(Node ... nodes) {
        Iterator<Tuple<NodeId>> _iter = this.findAsNodeIds(nodes);
        if (_iter == null) {
            return new NullIterator<Tuple<Node>>();
        }
        Iterator<Tuple<Node>> iter = TupleLib.convertToNodes(this.nodeTable, _iter);
        return iter;
    }

    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        NodeId[] n = new NodeId[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            NodeId id = this.idForNode(nodes[i]);
            if (id == NodeId.NodeDoesNotExist) {
                return null;
            }
            n[i] = id;
        }
        return this.find(n);
    }

    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        Tuple<NodeId> tuple = Tuple.create(ids);
        Iterator<Tuple<NodeId>> iter = this.tupleTable.find(tuple);
        return iter;
    }

    protected final NodeId idForNode(Node node) {
        if (node == null || node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        return this.nodeTable.getNodeIdForNode(node);
    }

    protected final NodeId storeNode(Node node) {
        return this.nodeTable.storeNode(node);
    }

    protected final Node retrieveNode(NodeId id) {
        return this.nodeTable.getNodeForNodeId(id);
    }

    public final TupleTable getTupleTable() {
        return this.tupleTable;
    }

    public final NodeTable getNodeTable() {
        return this.nodeTable;
    }

    public boolean isEmpty() {
        return this.tupleTable.isEmpty();
    }

    public long size() {
        return this.tupleTable.size();
    }

    public final void close() {
        this.tupleTable.close();
        this.nodeTable.close();
    }

    @Override
    public final void sync(boolean force) {
        this.tupleTable.sync(force);
        this.nodeTable.sync(force);
    }
}

