/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableIndex;
import com.hp.hpl.jena.tdb.nodetable.NodeTableSink;
import com.hp.hpl.jena.tdb.sys.SystemTDB;

public class NodeTableFactory {
    public static NodeTable create(IndexBuilder indexBuilder, Location location) {
        return NodeTableFactory.create(indexBuilder, location, "nodes.dat", "node2id", SystemTDB.Node2NodeIdCacheSize, SystemTDB.NodeId2NodeCacheSize);
    }

    public static NodeTable create(IndexBuilder indexBuilder, Location location, String tableName, String nodeTableIdxName, int nodeToIdCacheSize, int idToNodeCacheSize) {
        if (location == null) {
            return new NodeTableIndex(indexBuilder);
        }
        return new NodeTableIndex(indexBuilder, location, tableName, nodeTableIdxName, nodeToIdCacheSize, idToNodeCacheSize);
    }

    public static NodeTable createMem(IndexBuilder indexBuilder) {
        return new NodeTableIndex(indexBuilder);
    }

    public static NodeTable createSink(IndexBuilder indexBuilder, Location location) {
        return new NodeTableSink();
    }
}

