/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import lib.Cache;
import lib.CacheFactory;
import lib.CacheSetLRU;

public class NodeTableBase
implements NodeTable {
    protected ObjectFile objects;
    protected Index nodeHashToId;
    protected Cache<Node, NodeId> node2id_Cache = null;
    protected Cache<NodeId, Node> id2node_Cache = null;
    protected CacheSetLRU<Node> notPresent;

    protected NodeTableBase() {
    }

    public NodeTableBase(Index nodeToId, ObjectFile objectFile, int nodeToIdCacheSize, int idToNodeCacheSize) {
        this();
        this.init(nodeToId, objectFile, idToNodeCacheSize, idToNodeCacheSize);
    }

    protected void init(Index nodeToId, ObjectFile objectFile, int nodeToIdCacheSize, int idToNodeCacheSize) {
        this.nodeHashToId = nodeToId;
        this.objects = objectFile;
        if (nodeToIdCacheSize > 0) {
            this.node2id_Cache = CacheFactory.createCache(nodeToIdCacheSize);
        }
        if (idToNodeCacheSize > 0) {
            this.id2node_Cache = CacheFactory.createCache(idToNodeCacheSize);
        }
        this.notPresent = new CacheSetLRU(100);
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId storeNode(Node node) {
        return this._idForNode(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _retrieveNodeByNodeId(NodeId id) {
        if (id == NodeId.NodeDoesNotExist) {
            return null;
        }
        if (id == NodeId.NodeIdAny) {
            return null;
        }
        Node n = NodeId.extract(id);
        if (n != null) {
            return n;
        }
        NodeTableBase nodeTableBase = this;
        synchronized (nodeTableBase) {
            n = this.cacheLookup(id);
            if (n != null) {
                return n;
            }
            n = this.readNodeByNodeId(id);
            this.cacheUpdate(n, id);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = NodeId.inline(node);
        if (nodeId != null) {
            return nodeId;
        }
        NodeTableBase nodeTableBase = this;
        synchronized (nodeTableBase) {
            nodeId = this.cacheLookup(node);
            if (nodeId != null) {
                return nodeId;
            }
            nodeId = this.accessIndex(node, allocate);
            this.cacheUpdate(node, nodeId);
            return nodeId;
        }
    }

    protected NodeId accessIndex(Node node, boolean create) {
        Hash hash = new Hash(this.nodeHashToId.getRecordFactory().keyLength());
        NodeLib.setHash(hash, node);
        byte[] k = hash.getBytes();
        Record r = this.nodeHashToId.getRecordFactory().create(k);
        Record r2 = this.nodeHashToId.find(r);
        if (r2 != null) {
            NodeId id = NodeId.create(r2.getValue(), 0);
            return id;
        }
        if (!create) {
            return NodeId.NodeDoesNotExist;
        }
        NodeId id = this.writeNodeToTable(node);
        id.toBytes(r.getValue(), 0);
        if (!this.nodeHashToId.add(r)) {
            throw new TDBException("NodeTableBase::nodeToId - record mysteriously appeared");
        }
        return id;
    }

    protected Node cacheLookup(NodeId id) {
        if (this.id2node_Cache == null) {
            return null;
        }
        return this.id2node_Cache.getObject(id);
    }

    protected NodeId cacheLookup(Node node) {
        if (this.notPresent.contains(node)) {
            return null;
        }
        if (this.node2id_Cache == null) {
            return null;
        }
        return this.node2id_Cache.getObject(node);
    }

    protected void cacheUpdate(Node node, NodeId id) {
        if (id == NodeId.NodeDoesNotExist) {
            this.notPresent.add(node);
            return;
        }
        if (id == NodeId.NodeIdAny) {
            ALog.warn((Object)this, (String)"Attempt to cache NodeIdAny - ignored");
            return;
        }
        if (this.node2id_Cache != null) {
            this.node2id_Cache.putObject(node, id);
        }
        if (this.id2node_Cache != null) {
            this.id2node_Cache.putObject(id, node);
        }
        if (this.notPresent.contains(node)) {
            this.notPresent.remove(node);
        }
    }

    protected final NodeId writeNodeToTable(Node node) {
        String s = NodeLib.encode(node);
        return this.getObjects().write(s);
    }

    protected final Node readNodeByNodeId(NodeId id) {
        String s = this.getObjects().read(id);
        Node n = NodeLib.decode(s);
        return n;
    }

    public synchronized void close() {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.close();
        }
        if (this.getObjects() != null) {
            this.getObjects().close();
        }
    }

    @Override
    public synchronized void sync(boolean force) {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.sync(force);
        }
        if (this.getObjects() != null) {
            this.getObjects().sync(force);
        }
    }

    public ObjectFile getObjects() {
        return this.objects;
    }
}

