/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.lib;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.NodeType;
import iterator.Iter;
import iterator.Transform;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import lib.Bytes;

public class NodeLib {
    public static String encode(Node node) {
        return NodeLib.encode(node, null);
    }

    public static String encode(Node node, PrefixMapping pmap) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        if (node.isURI() && node.getURI().indexOf(32) >= 0) {
            throw new TDBException("Space found in URI: " + node);
        }
        return FmtUtils.stringForNode((Node)node, (PrefixMapping)pmap);
    }

    public static Node decode(String s) {
        return NodeLib.decode(s, null);
    }

    public static Node decode(String s, PrefixMapping pmap) {
        if (s.startsWith("_:")) {
            s = s.substring(2);
            return Node.createAnon((AnonId)new AnonId(s));
        }
        try {
            return SSE.parseNode((String)s, (PrefixMapping)pmap);
        }
        catch (SSEParseException ex) {
            ALog.fatal(NodeLib.class, (String)("decode: Failed to parse: " + s));
            throw ex;
        }
    }

    public static Hash hash(Node n) {
        Hash h = new Hash(8);
        NodeLib.setHash(h, n);
        return h;
    }

    public static void setHash(Hash h, Node n) {
        NodeType nt = NodeType.lookup(n);
        switch (nt) {
            case URI: {
                NodeLib.hash(h, n.getURI(), null, null, nt);
                return;
            }
            case BNODE: {
                NodeLib.hash(h, n.getBlankNodeLabel(), null, null, nt);
                return;
            }
            case LITERAL: {
                NodeLib.hash(h, n.getLiteralLexicalForm(), n.getLiteralLanguage(), n.getLiteralDatatypeURI(), nt);
                return;
            }
            case OTHER: {
                throw new TDBException("Attempt to hash something strange: " + n);
            }
        }
        throw new TDBException("NodeType broken: " + n);
    }

    private static void hash(Hash h, String lex, String lang, String datatype, NodeType nodeType) {
        if (datatype == null) {
            datatype = "";
        }
        if (lang == null) {
            lang = "";
        }
        String toHash = lex + "|" + lang + "|" + datatype + "|" + nodeType.getName();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(toHash.getBytes("UTF8"));
            if (h.getLen() == 16) {
                digest.digest(h.getBytes(), 0, 16);
            } else {
                byte[] b = digest.digest();
                System.arraycopy(b, 0, h.getBytes(), 0, h.getLen());
            }
            return;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (DigestException ex) {
            ex.printStackTrace();
        }
    }

    public static NodeId getNodeId(Record r, int idx) {
        return NodeId.create(Bytes.getLong(r.getKey(), idx));
    }

    public static Node termOrAny(Node node) {
        if (node == null || node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static Iterator<Node> nodes(final NodeTable nodeTable, Iterator<NodeId> iter) {
        return Iter.map(iter, new Transform<NodeId, Node>(){

            @Override
            public Node convert(NodeId item) {
                return nodeTable.getNodeForNodeId(item);
            }
        });
    }
}

