/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.SurpressedTest;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.junit.QueryTestTDB;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestFactoryTDB
extends TestFactoryManifest {
    public static EarlReport report = null;
    public String testRootName;
    private TDBFactory.ImplFactory factory;

    public static void make(TestSuite ts, String manifestFile, String testRootName, TDBFactory.ImplFactory factory) {
        TestSuite ts2 = TestFactoryTDB.makeSuite(manifestFile, testRootName, factory);
        ts.addTest((Test)ts2);
    }

    public static TestSuite makeSuite(String manifestFile, String testRootName, TDBFactory.ImplFactory factory) {
        TestFactoryTDB f = new TestFactoryTDB(testRootName, factory);
        TestSuite ts = f.process(manifestFile);
        if (testRootName != null) {
            ts.setName(testRootName + ts.getName());
        }
        return ts;
    }

    public TestFactoryTDB(String testRootName, TDBFactory.ImplFactory factory) {
        this.testRootName = testRootName;
        this.factory = factory;
    }

    protected Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        if (this.testRootName != null) {
            testName = this.testRootName + testName;
        }
        TestItem testItem = new TestItem(entry, null, Syntax.syntaxARQ, DataFormat.langXML);
        QueryTestTDB test = null;
        if (testItem.getTestType() != null) {
            if (testItem.getTestType().equals(TestManifestX.TestQuery)) {
                test = new QueryTestTDB(testName, report, testItem, this.factory);
            }
            if (testItem.getTestType().equals(TestManifestX.TestSurpressed)) {
                test = new SurpressedTest(testName, report, testItem);
            }
            if (test == null) {
                System.err.println("Unrecognized test type: " + testItem.getTestType());
            }
        }
        if (test == null) {
            test = new QueryTestTDB(testName, report, testItem, this.factory);
        }
        return test;
    }
}

