/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.resultset.RSCompare;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.junit.TDBTestException;
import com.hp.hpl.jena.util.FileManager;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTestTDB
extends EarlTestCase {
    private static Logger log = LoggerFactory.getLogger(QueryTestTDB.class);
    private Dataset dataset = null;
    boolean skipThisTest = false;
    TestItem item;
    private TDBFactory.ImplFactory factory;
    private static List<String> currentDefaultGraphs = null;
    private static List<String> currentNamedGraphs = null;

    public QueryTestTDB(String testName, EarlReport report, TestItem item, TDBFactory.ImplFactory factory) {
        super(testName, item.getURI(), report);
        this.item = item;
        this.factory = factory;
    }

    public void setUp() {
        this.dataset = TDBFactory.createDataset();
        this.setupData();
    }

    public void tearDown() {
        if (this.dataset != null) {
            this.dataset.close();
        }
    }

    public void setupData() {
        List current = this.item.getDefaultGraphURIs();
        List named = this.item.getNamedGraphURIs();
        if (QueryTestTDB.compareLists(current, currentDefaultGraphs) && QueryTestTDB.compareLists(named, currentNamedGraphs)) {
            return;
        }
        if (current == null) {
            throw new TDBTestException("No default graphs given");
        }
        for (String fn : current) {
            QueryTestTDB.load(this.dataset.getDefaultModel(), fn);
        }
        for (String fn : named) {
            QueryTestTDB.load(this.dataset.getNamedModel(fn), fn);
        }
    }

    protected void runTestForReal() throws Throwable {
        if (this.skipThisTest) {
            log.info(this.getName() + " : Skipped");
            return;
        }
        Query query = QueryFactory.read((String)this.item.getQueryFile());
        Object oldValue = ARQ.getContext().get(ARQ.strictGraph);
        ARQ.setTrue((Symbol)ARQ.strictGraph);
        Dataset ds = DatasetFactory.create((List)this.item.getDefaultGraphURIs(), (List)this.item.getNamedGraphURIs());
        ARQ.getContext().set(ARQ.strictGraph, oldValue);
        ResultSet rs = this.item.getResultSet();
        ResultSetRewindable rs1 = null;
        String expectedLabel = "";
        if (rs != null) {
            rs1 = ResultSetFactory.makeRewindable((ResultSet)rs);
            expectedLabel = "Results file";
        } else {
            QueryEngineFactory f = QueryEngineRef.getFactory();
            QueryExecutionBase qExec1 = new QueryExecutionBase(query, ds, null, f);
            rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec1.execSelect());
            qExec1.close();
            expectedLabel = "Standard engine";
        }
        Dataset ds2 = this.dataset;
        QueryExecution qExec2 = QueryExecutionFactory.create((Query)query, (Dataset)ds2);
        rs = qExec2.execSelect();
        ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)rs);
        boolean b = RSCompare.same((ResultSet)rs1, (ResultSet)rs2);
        if (!b) {
            rs1.reset();
            rs2.reset();
            System.out.println("------------------- " + this.getName());
            System.out.printf("**** Expected (%s)", expectedLabel);
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs1);
            System.out.println("**** Got (TDB)");
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs2);
        }
        QueryTestTDB.assertTrue((String)"Results sets not the same", (boolean)b);
    }

    private static void load(Model model, String fn) {
        FileManager.get().readModel(model, fn);
    }

    private static boolean compareLists(List<String> list1, List<String> list2) {
        if (list1 == null) {
            return list2 == null;
        }
        return ((Object)list1).equals(list2);
    }
}

