/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.junit;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.junit.TDBTestException;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import iterator.Iter;
import java.util.Iterator;
import java.util.List;
import lib.FileOps;

public class GraphLocation {
    private Location loc = null;
    private Graph graph = null;
    private Model model = null;
    private DatasetGraphTDB dsg = null;
    private TDBFactory.ImplFactory factory;

    public GraphLocation(Location loc, TDBFactory.ImplFactory factory) {
        this.loc = loc;
        this.factory = factory;
    }

    public void clearDirectory() {
        FileOps.clearDirectory(this.loc.getDirectoryPath());
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Model getModel() {
        return this.model;
    }

    public Dataset getDataset() {
        if (this.dsg == null) {
            return null;
        }
        return new DatasetImpl((DatasetGraph)this.dsg);
    }

    public Dataset createDataset() {
        if (this.dsg != null) {
            throw new TDBTestException("dataset already in use");
        }
        this.dsg = (DatasetGraphTDB)this.factory.createDatasetGraph(this.loc);
        return new DatasetImpl((DatasetGraph)this.dsg);
    }

    public Graph createGraph() {
        if (this.graph != null) {
            throw new TDBTestException("Graph already in use");
        }
        this.graph = this.factory.createGraph(this.loc);
        this.model = ModelFactory.createModelForGraph((Graph)this.graph);
        return this.graph;
    }

    public void clearGraph() {
        if (this.graph != null) {
            Iterator iter = Iter.convert(this.graph.find(Node.ANY, Node.ANY, Node.ANY));
            List<Triple> triples = Iter.toList(iter);
            for (Triple t : triples) {
                this.graph.delete(t);
            }
        }
    }

    public void release() {
        if (this.graph != null) {
            this.graph.close();
            this.graph = null;
            this.model = null;
        }
        if (this.dsg != null) {
            this.dsg.close();
            this.dsg = null;
        }
    }
}

