/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.file.PlainFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.ext.ExtHash;

public class IndexFactoryExtHash
implements IndexFactory {
    private final int blockSize;

    public IndexFactoryExtHash(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public Index createIndex(Location location, String name, RecordFactory recordFactory) {
        String fnDictionary = location.getPath(name, "exh");
        PlainFile dictionary = FileFactory.createPlainFileDisk(fnDictionary);
        String fnBuckets = location.getPath(name, "dat");
        BlockMgr mgr = BlockMgrFactory.createFile(fnBuckets, this.blockSize);
        ExtHash eHash = new ExtHash(dictionary, recordFactory, mgr);
        return eHash;
    }

    protected BlockMgr createBlockMgr(String filename, int blockSize) {
        return BlockMgrFactory.createFile(filename, blockSize);
    }
}

