/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.btree.BTree;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;

public class IndexFactoryBTree
implements IndexFactory,
IndexRangeFactory {
    private final int blockSize;

    public IndexFactoryBTree(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public Index createIndex(Location location, String name, RecordFactory recordFactory) {
        return this.createRangeIndex(location, name, recordFactory);
    }

    @Override
    public RangeIndex createRangeIndex(Location location, String name, RecordFactory recordFactory) {
        int order = BTreeParams.calcOrder(this.blockSize, recordFactory);
        BTreeParams params = new BTreeParams(order, recordFactory);
        BTree bTree = new BTree(params, this.createBlockMgr(location.getPath(name, "idx"), this.blockSize));
        return bTree;
    }

    protected BlockMgr createBlockMgr(String filename, int blockSize) {
        return BlockMgrFactory.createFile(filename, blockSize);
    }
}

