/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;

public class IndexFactoryBPlusTreeMem
implements IndexFactory,
IndexRangeFactory {
    private final int order;

    public IndexFactoryBPlusTreeMem(int order) {
        this.order = order;
    }

    @Override
    public Index createIndex(Location location, String name, RecordFactory recordFactory) {
        return this.createRangeIndex(location, name, recordFactory);
    }

    @Override
    public RangeIndex createRangeIndex(Location location, String name, RecordFactory recordFactory) {
        int blkSize = BPlusTreeParams.calcBlockSize(this.order, recordFactory);
        BPlusTreeParams params = new BPlusTreeParams(this.order, recordFactory);
        BlockMgr blkMgr1 = BlockMgrFactory.createMem(name, blkSize);
        BlockMgr blkMgr2 = BlockMgrFactory.createMem(name, blkSize);
        BPlusTree bTree = BPlusTree.attach(params, blkMgr1, blkMgr2);
        return bTree;
    }
}

